/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import hunternif.mc.impl.atlas.client.OverlayRenderer;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemInHandRenderer.class})
public abstract class HeldItemRendererMixin {
    private OverlayRenderer atlasOverlayRenderer = new OverlayRenderer();
    @Shadow
    private ItemStack offHandItem;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private ItemStack mainHandItem;

    @Shadow
    protected abstract void renderMapHand(PoseStack var1, MultiBufferSource var2, int var3, HumanoidArm var4);

    @Shadow
    protected abstract void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Shadow
    protected abstract float calculateMapTilt(float var1);

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void renderAtlas(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci, boolean bl, HumanoidArm arm) {
        if (item.getItem() == AntiqueAtlasItems.Items.ATLAS) {
            if (bl && this.offHandItem.isEmpty()) {
                this.renderAtlasInBothHands(matrices, vertexConsumers, light, pitch, equipProgress, swingProgress);
            } else {
                this.renderAtlasInOneHand(matrices, vertexConsumers, light, equipProgress, arm, swingProgress, item);
            }
            matrices.popPose();
            ci.cancel();
        }
    }

    private void renderAtlasInBothHands(PoseStack matrices, MultiBufferSource vertexConsumers, int light, float pitch, float equipProgress, float swingProgress) {
        float f = Mth.sqrt((float)swingProgress);
        float g = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
        float h = -0.4f * Mth.sin((float)(f * (float)Math.PI));
        matrices.translate(0.0, (double)(-g / 2.0f), (double)h);
        float i = this.calculateMapTilt(pitch);
        matrices.translate(0.0, (double)(0.04f + equipProgress * -1.2f + i * -0.5f), (double)-0.72f);
        matrices.mulPose(Axis.XP.rotationDegrees(i * -85.0f));
        if (!this.minecraft.player.isInvisible()) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.renderMapHand(matrices, vertexConsumers, light, HumanoidArm.RIGHT);
            this.renderMapHand(matrices, vertexConsumers, light, HumanoidArm.LEFT);
            matrices.popPose();
        }
        float j = Mth.sin((float)(f * (float)Math.PI));
        matrices.mulPose(Axis.XP.rotationDegrees(j * 20.0f));
        matrices.scale(0.5f, 0.5f, 1.0f);
        this.renderFirstPersonAtlas(matrices, vertexConsumers, light, this.mainHandItem);
    }

    private void renderAtlasInOneHand(PoseStack matrices, MultiBufferSource vertexConsumers, int light, float equipProgress, HumanoidArm arm, float swingProgress, ItemStack item) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        matrices.pushPose();
        matrices.translate((double)(f * 0.125f), -0.125, 0.0);
        if (!this.minecraft.player.isInvisible()) {
            matrices.pushPose();
            matrices.mulPose(Axis.ZP.rotationDegrees(f * 10.0f));
            this.renderPlayerArm(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
            matrices.popPose();
        }
        matrices.translate((double)(f * 0.51f), (double)(-0.08f + equipProgress * -1.2f), -0.75);
        float g = Mth.sqrt((float)swingProgress);
        float h = Mth.sin((float)(g * (float)Math.PI));
        float i = -0.5f * h;
        float j = 0.4f * Mth.sin((float)(g * ((float)Math.PI * 2)));
        float k = -0.3f * Mth.sin((float)(swingProgress * (float)Math.PI));
        matrices.translate(f * i, j - 0.3f * h, k);
        matrices.mulPose(Axis.XP.rotationDegrees(h * -45.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(f * h * -30.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrices.scale(0.38f, 0.38f, 0.38f);
        matrices.translate(-0.75, -0.5, 0.0);
        matrices.scale(0.0078125f, 0.0078125f, 0.0078125f);
        matrices.scale(0.4f, 0.4f, 0.4f);
        this.atlasOverlayRenderer.drawOverlay(matrices, vertexConsumers, light, item);
        matrices.popPose();
    }

    private void renderFirstPersonAtlas(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack item) {
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrices.scale(0.38f, 0.38f, 0.38f);
        matrices.translate(-1.85, -0.5, 0.0);
        matrices.scale(0.0078125f, 0.0078125f, 0.0078125f);
        this.atlasOverlayRenderer.drawOverlay(matrices, vertexConsumers, light, item);
    }
}

