/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.mixinhooks;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.item.AtlasItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class CartographyTableHooks {
    public static void onTakeItem(Player player, ItemStack map, ItemStack atlas) {
        MapItemSavedData mapState;
        if (player.getCommandSenderWorld().isClientSide()) {
            return;
        }
        if (map.getItem() == Items.FILLED_MAP && (mapState = MapItem.getSavedData((MapId)((MapId)map.get(DataComponents.MAP_ID)), (Level)player.getCommandSenderWorld())) != null) {
            mapState.getDecorations().forEach(icon -> {
                int i = 1 << mapState.scale;
                int x = (int)((float)((int)((float)icon.x() - 0.5f)) / 2.0f) * i + mapState.centerX;
                int z = (int)((float)((int)((float)icon.y() - 0.5f)) / 2.0f) * i + mapState.centerZ;
                ResourceLocation type = null;
                MutableComponent label = null;
                if (icon.type() == MapDecorationTypes.RED_X) {
                    type = AntiqueAtlas.id("red_x_small");
                    label = Component.translatable((String)"gui.antiqueatlas.marker.treasure");
                } else if (icon.type() == MapDecorationTypes.OCEAN_MONUMENT) {
                    type = AntiqueAtlas.id("monument");
                    label = Component.translatable((String)"gui.antiqueatlas.marker.monument");
                } else if (icon.type() == MapDecorationTypes.WOODLAND_MANSION) {
                    type = AntiqueAtlas.id("mansion");
                    label = Component.translatable((String)"gui.antiqueatlas.marker.mansion");
                }
                if (type != null) {
                    AtlasAPI.getMarkerAPI().putMarker(player.getCommandSenderWorld(), true, AtlasItem.getAtlasID(atlas), type, (Component)label, x, z);
                }
            });
        }
    }
}

