/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DeleteMarkerC2SPacket
extends ServerboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "c2s", "marker", "delete");
    private static final int GLOBAL = -1;
    int atlasID;
    int markerID;

    public DeleteMarkerC2SPacket(int atlasID, int markerID) {
        super(null);
        this.atlasID = atlasID;
        this.markerID = markerID;
    }

    public DeleteMarkerC2SPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        this.atlasID = packetBuffer.readInt();
        this.markerID = packetBuffer.readInt();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.atlasID);
        packetBuffer.writeInt(this.markerID);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (AntiqueAtlas.CONFIG.itemNeeded && !AtlasAPI.getPlayerAtlases((Player)sender).contains(this.atlasID)) {
            Log.warn("Player %s attempted to delete marker from someone else's Atlas #%d", sender.getName(), this.atlasID);
            return true;
        }
        AtlasAPI.getMarkerAPI().deleteMarker(sender.level(), this.atlasID, this.markerID);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

