/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PutBrowsingPositionC2SPacket
extends ServerboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "c2s", "browsing_position", "put");
    int atlasID;
    int x;
    int y;
    double zoom;
    ResourceKey<Level> world;

    public PutBrowsingPositionC2SPacket(int atlasID, ResourceKey<Level> world, int x, int y, double zoom) {
        super(null);
        this.atlasID = atlasID;
        this.world = world;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public PutBrowsingPositionC2SPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        this.atlasID = packetBuffer.readVarInt();
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packetBuffer.readResourceLocation());
        this.x = packetBuffer.readVarInt();
        this.y = packetBuffer.readVarInt();
        this.zoom = packetBuffer.readDouble();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeVarInt(this.atlasID);
        packetBuffer.writeResourceLocation(this.world.location());
        packetBuffer.writeVarInt(this.x);
        packetBuffer.writeVarInt(this.y);
        packetBuffer.writeDouble(this.zoom);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (AntiqueAtlas.CONFIG.itemNeeded && !AtlasAPI.getPlayerAtlases((Player)sender).contains(this.atlasID)) {
            Log.warn("Player %s attempted to put position marker into someone else's Atlas #%d", sender.getName(), this.atlasID);
            return false;
        }
        AntiqueAtlas.tileData.getData(this.atlasID, sender.level()).getWorldData(this.world).setBrowsingPosition(this.x, this.y, this.zoom);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

