/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PutMarkerC2SPacket
extends ServerboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "c2s", "marker", "put");
    int atlasID;
    int x;
    int z;
    boolean visibleBeforeDiscovery;
    ResourceLocation markerType;
    Component label;

    public PutMarkerC2SPacket(int atlasID, ResourceLocation markerType, int x, int z, boolean visibleBeforeDiscovery, Component label) {
        super(null);
        this.atlasID = atlasID;
        this.markerType = markerType;
        this.x = x;
        this.z = z;
        this.visibleBeforeDiscovery = visibleBeforeDiscovery;
        this.label = label;
    }

    public PutMarkerC2SPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        this.atlasID = packetBuffer.readVarInt();
        this.markerType = packetBuffer.readResourceLocation();
        this.x = packetBuffer.readVarInt();
        this.z = packetBuffer.readVarInt();
        this.visibleBeforeDiscovery = packetBuffer.readBoolean();
        this.label = Component.Serializer.fromJson((String)packetBuffer.readUtf(), (HolderLookup.Provider)packetBuffer.registryAccess());
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeVarInt(this.atlasID);
        packetBuffer.writeResourceLocation(this.markerType);
        packetBuffer.writeVarInt(this.x);
        packetBuffer.writeVarInt(this.z);
        packetBuffer.writeBoolean(this.visibleBeforeDiscovery);
        packetBuffer.writeUtf(Component.Serializer.toJson((Component)this.label, (HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (!AtlasAPI.getPlayerAtlases((Player)sender).contains(this.atlasID)) {
            AntiqueAtlas.LOG.warn("Player {} attempted to put marker into someone else's Atlas #{}}", (Object)sender.getName(), (Object)this.atlasID);
            return false;
        }
        AtlasAPI.getMarkerAPI().putMarker(sender.level(), this.visibleBeforeDiscovery, this.atlasID, this.markerType, this.label, this.x, this.z);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

