/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PutTileC2SPacket
extends ServerboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "c2s", "tile", "put");
    int atlasID;
    int x;
    int z;
    ResourceLocation tile;

    public PutTileC2SPacket(int atlasID, int x, int z, ResourceLocation tile) {
        super(null);
        this.atlasID = atlasID;
        this.tile = tile;
        this.x = x;
        this.z = z;
    }

    public PutTileC2SPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        this.atlasID = packetBuffer.readVarInt();
        this.tile = packetBuffer.readResourceLocation();
        this.x = packetBuffer.readVarInt();
        this.z = packetBuffer.readVarInt();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeVarInt(this.atlasID);
        packetBuffer.writeResourceLocation(this.tile);
        packetBuffer.writeVarInt(this.x);
        packetBuffer.writeVarInt(this.z);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (AntiqueAtlas.CONFIG.itemNeeded && !AtlasAPI.getPlayerAtlases((Player)sender).contains(this.atlasID)) {
            Log.warn("Player %s attempted to modify someone else's Atlas #%d", sender.getName(), this.atlasID);
            return false;
        }
        AtlasAPI.getTileAPI().putTile(sender.level(), this.atlasID, this.tile, this.x, this.z);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

