/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DeleteGlobalTileS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "c2s", "global_tile", "delete");
    ResourceKey<Level> world;
    int chunkX;
    int chunkZ;

    public DeleteGlobalTileS2CPacket(ResourceKey<Level> world, int chunkX, int chunkZ) {
        super(null);
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public DeleteGlobalTileS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        this.chunkX = byteBuf.readVarInt();
        this.chunkZ = byteBuf.readVarInt();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.chunkX);
        byteBuf.writeVarInt(this.chunkZ);
    }

    public boolean runOnClient(Player sender) {
        TileDataStorage data = AntiqueAtlas.globalTileData.getData(this.world);
        data.removeTile(this.chunkX, this.chunkZ);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

