/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.AntiqueAtlasClientSegment;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class DeleteMarkerS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "marker", "delete");
    private static final int GLOBAL = -1;
    int atlasID;
    int markerID;

    public DeleteMarkerS2CPacket(int atlasID, int markerID) {
        super(null);
        this.atlasID = atlasID;
        this.markerID = markerID;
    }

    public DeleteMarkerS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.markerID = byteBuf.readVarInt();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeVarInt(this.atlasID);
        byteBuf.writeVarInt(this.markerID);
    }

    public boolean runOnClient(Player sender) {
        GlobalMarkersData data = this.atlasID == -1 ? AntiqueAtlas.globalMarkersData.getData() : AntiqueAtlas.markersData.getMarkersData(this.atlasID, sender.level());
        data.removeMarker(this.markerID);
        AntiqueAtlasClientSegment.getAtlasGUI().updateBookmarkerList();
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

