/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DimensionUpdateS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "dimension", "update");
    int atlasID;
    ResourceKey<Level> world;
    Collection<TileInfo> tiles;

    public DimensionUpdateS2CPacket(int atlasID, ResourceKey<Level> world, Collection<TileInfo> tiles) {
        super(null);
        this.atlasID = atlasID;
        this.world = world;
        this.tiles = tiles;
    }

    public DimensionUpdateS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        int tileCount = byteBuf.readVarInt();
        this.tiles = new ArrayList<TileInfo>();
        for (int i = 0; i < tileCount; ++i) {
            this.tiles.add(new TileInfo(byteBuf.readVarInt(), byteBuf.readVarInt(), byteBuf.readResourceLocation()));
        }
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeVarInt(this.atlasID);
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.tiles.size());
        for (TileInfo tile : this.tiles) {
            byteBuf.writeVarInt(tile.x);
            byteBuf.writeVarInt(tile.z);
            byteBuf.writeResourceLocation(tile.id);
        }
    }

    public boolean runOnClient(Player sender) {
        AtlasData data = AntiqueAtlas.tileData.getData(this.atlasID, sender.level());
        for (TileInfo info : this.tiles) {
            data.getWorldData(this.world).setTile(info.x, info.z, info.id);
        }
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

