/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MapDataS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "map", "data");
    int atlasID;
    CompoundTag data;

    public MapDataS2CPacket(int atlasID, CompoundTag data) {
        super(null);
        this.atlasID = atlasID;
        this.data = data;
    }

    public MapDataS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.data = byteBuf.readNbt();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeVarInt(this.atlasID);
        byteBuf.writeNbt((Tag)this.data);
    }

    public boolean runOnClient(Player sender) {
        Screen screen;
        AtlasData atlasData = AntiqueAtlas.tileData.getData(this.atlasID, sender.level());
        atlasData.updateFromNbt(this.data);
        if (AntiqueAtlas.CONFIG.doSaveBrowsingPos && (screen = Minecraft.getInstance().screen) instanceof GuiAtlas) {
            GuiAtlas atlas = (GuiAtlas)screen;
            atlas.loadSavedBrowsingPosition();
        }
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

