/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class PutGlobalTileS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "global_tile", "put");
    ResourceKey<Level> world;
    List<Map.Entry<ChunkPos, ResourceLocation>> tiles;

    public PutGlobalTileS2CPacket(ResourceKey<Level> world, List<Map.Entry<ChunkPos, ResourceLocation>> tiles) {
        super(null);
        this.world = world;
        this.tiles = tiles;
    }

    public PutGlobalTileS2CPacket(ResourceKey<Level> world, final int chunkX, final int chunkZ, final ResourceLocation tileId) {
        super(null);
        this.world = world;
        this.tiles = new ArrayList<Map.Entry<ChunkPos, ResourceLocation>>();
        this.tiles.add(new Map.Entry<ChunkPos, ResourceLocation>(){

            @Override
            public ChunkPos getKey() {
                return new ChunkPos(chunkX, chunkZ);
            }

            @Override
            public ResourceLocation getValue() {
                return tileId;
            }

            @Override
            public ResourceLocation setValue(ResourceLocation arg0) {
                return tileId;
            }
        });
    }

    public PutGlobalTileS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        this.tiles = new ArrayList<Map.Entry<ChunkPos, ResourceLocation>>();
        int max = byteBuf.readVarInt();
        for (int i = 0; i < max; ++i) {
            final ChunkPos chunk = new ChunkPos(byteBuf.readVarInt(), byteBuf.readVarInt());
            final ResourceLocation loc = byteBuf.readResourceLocation();
            this.tiles.add(new Map.Entry<ChunkPos, ResourceLocation>(){

                @Override
                public ChunkPos getKey() {
                    return chunk;
                }

                @Override
                public ResourceLocation getValue() {
                    return loc;
                }

                @Override
                public ResourceLocation setValue(ResourceLocation arg0) {
                    return loc;
                }
            });
        }
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.tiles.size());
        for (Map.Entry<ChunkPos, ResourceLocation> entry : this.tiles) {
            byteBuf.writeVarInt(entry.getKey().x);
            byteBuf.writeVarInt(entry.getKey().z);
            byteBuf.writeResourceLocation(entry.getValue());
        }
    }

    public boolean runOnClient(Player sender) {
        TileDataStorage data = AntiqueAtlas.globalTileData.getData(this.world);
        this.tiles.forEach(entry -> data.setTile(((ChunkPos)entry.getKey()).x, ((ChunkPos)entry.getKey()).z, (ResourceLocation)entry.getValue()));
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

