/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.AntiqueAtlasClientSegment;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PutMarkersS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "marker", "put");
    private static final int GLOBAL = -1;
    int atlasID;
    ResourceKey<Level> world;
    ListMultimap<ResourceLocation, Marker.Precursor> markersByType;

    public PutMarkersS2CPacket(int atlasID, ResourceKey<Level> world, Collection<Marker> markers) {
        super(null);
        this.atlasID = atlasID;
        this.world = world;
        this.markersByType = ArrayListMultimap.create();
        for (Marker marker : markers) {
            this.markersByType.put((Object)marker.getType(), (Object)new Marker.Precursor(marker));
        }
    }

    public PutMarkersS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        int typesLength = byteBuf.readVarInt();
        this.markersByType = ArrayListMultimap.create();
        for (int i = 0; i < typesLength; ++i) {
            ResourceLocation type = byteBuf.readResourceLocation();
            int markersLength = byteBuf.readVarInt();
            for (int j = 0; j < markersLength; ++j) {
                this.markersByType.put((Object)type, (Object)new Marker.Precursor((FriendlyByteBuf)byteBuf));
            }
        }
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeVarInt(this.atlasID);
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.markersByType.keySet().size());
        for (ResourceLocation type : this.markersByType.keySet()) {
            byteBuf.writeResourceLocation(type);
            List markerList = this.markersByType.get((Object)type);
            byteBuf.writeVarInt(markerList.size());
            for (Marker.Precursor marker : markerList) {
                new Marker(type, this.world, marker).write(byteBuf);
            }
        }
    }

    public boolean runOnClient(Player sender) {
        GlobalMarkersData markersData = this.atlasID == -1 ? AntiqueAtlas.globalMarkersData.getData() : AntiqueAtlas.markersData.getMarkersDataCached(this.atlasID, this.world);
        for (ResourceLocation type : this.markersByType.keys()) {
            MarkerType markerType = (MarkerType)MarkerType.REGISTRY.get(type);
            for (Marker.Precursor precursor : this.markersByType.get((Object)type)) {
                ((MarkersData)markersData).loadMarker(new Marker(MarkerType.REGISTRY.getKey((Object)markerType), this.world, precursor));
            }
        }
        AntiqueAtlasClientSegment.getAtlasGUI().updateBookmarkerList();
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

