/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PutTileS2CPacket
extends ClientboundUnionPacket {
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "tile", "put");
    int atlasID;
    ResourceKey<Level> world;
    int x;
    int z;
    ResourceLocation tile;

    public PutTileS2CPacket(int atlasID, ResourceKey<Level> world, int x, int z, ResourceLocation tile) {
        super(null);
        this.atlasID = atlasID;
        this.world = world;
        this.x = x;
        this.z = z;
        this.tile = tile;
    }

    public PutTileS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        this.x = byteBuf.readVarInt();
        this.z = byteBuf.readVarInt();
        this.tile = byteBuf.readResourceLocation();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.atlasID);
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.x);
        byteBuf.writeVarInt(this.z);
        byteBuf.writeResourceLocation(this.tile);
    }

    public boolean runOnClient(Player sender) {
        AtlasData data = AntiqueAtlas.tileData.getData(this.atlasID, sender.level());
        data.setTile(this.world, this.x, this.z, this.tile);
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

