/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.core.WorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TileGroupsS2CPacket
extends ClientboundUnionPacket {
    public static final int TILE_GROUPS_PER_PACKET = 100;
    public static final ResourceLocation ID = AntiqueAtlas.id("packet", "s2c", "tile", "groups");
    int atlasID;
    ResourceKey<Level> world;
    List<TileGroup> tileGroups;

    public TileGroupsS2CPacket(int atlasID, ResourceKey<Level> world, List<TileGroup> tileGroups) {
        super(null);
        this.atlasID = atlasID;
        this.world = world;
        this.tileGroups = tileGroups;
    }

    public TileGroupsS2CPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.atlasID = byteBuf.readVarInt();
        this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)byteBuf.readResourceLocation());
        int length = byteBuf.readVarInt();
        this.tileGroups = new ArrayList<TileGroup>(length);
        for (int i = 0; i < length; ++i) {
            CompoundTag tag = byteBuf.readNbt();
            if (tag == null) continue;
            this.tileGroups.add(TileGroup.fromNBT(tag));
        }
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeVarInt(this.atlasID);
        byteBuf.writeResourceLocation(this.world.location());
        byteBuf.writeVarInt(this.tileGroups.size());
        for (TileGroup tileGroup : this.tileGroups) {
            byteBuf.writeNbt((Tag)tileGroup.writeToNBT(new CompoundTag()));
        }
    }

    public boolean runOnClient(Player sender) {
        AtlasData atlasData = AntiqueAtlas.tileData.getData(this.atlasID, sender.level());
        WorldData worldData = atlasData.getWorldData(this.world);
        for (TileGroup t : this.tileGroups) {
            worldData.putTileGroup(t);
        }
        return true;
    }

    public ResourceLocation id() {
        return ID;
    }
}

