/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.apache.commons.lang3.tuple.Triple;

public class StructureHandler {
    private static final HashMultimap<ResourceLocation, Tuple<ResourceLocation, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final Multimap<ResourceLocation, Tuple<ResourceLocation, Setter>> JIGSAW_TO_TILE_MAP = HashMultimap.create();
    private static final Map<ResourceLocation, Tuple<ResourceLocation, Component>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap<ResourceLocation, Tuple<ResourceLocation, Component>>();
    private static final Map<ResourceLocation, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap<ResourceLocation, Integer>();
    public static final Setter ALWAYS = (world, element, box, rotation) -> Collections.singleton(new ChunkPos(MathUtil.getCenter(box).getX() >> 4, MathUtil.getCenter(box).getZ() >> 4));
    private static final Set<Triple<Integer, Integer, ResourceLocation>> VISITED_STRUCTURES = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Collection<ChunkPos> IF_X_DIRECTION(Level ignoredWorld, StructurePoolElement ignoredElement, BoundingBox box, StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            List junctions = poolPiece.getJunctions();
            if (junctions.size() == 2) {
                if (((JigsawJunction)junctions.get(0)).getSourceX() == ((JigsawJunction)junctions.get(1)).getSourceX() || ((JigsawJunction)junctions.get(0)).getSourceZ() != ((JigsawJunction)junctions.get(1)).getSourceZ()) {
                    return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
                }
            } else {
                return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
            }
        }
        return Collections.emptyList();
    }

    public static Collection<ChunkPos> IF_Z_DIRECTION(Level ignoredWorld, StructurePoolElement ignoredElement, BoundingBox box, StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            List junctions = poolPiece.getJunctions();
            if (junctions.size() == 2) {
                if (((JigsawJunction)junctions.get(0)).getSourceZ() == ((JigsawJunction)junctions.get(1)).getSourceZ() || ((JigsawJunction)junctions.get(0)).getSourceX() != ((JigsawJunction)junctions.get(1)).getSourceX()) {
                    return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
                }
            } else {
                return Collections.singleton(new ChunkPos(MathUtil.getCenter(box)));
            }
        }
        return Collections.emptyList();
    }

    public static void registerTile(StructurePieceType structurePieceType, int priority, ResourceLocation textureId, Setter setter) {
        ResourceLocation id = BuiltInRegistries.STRUCTURE_PIECE.getKey((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new Tuple((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(textureId, priority);
    }

    public static void registerTile(StructurePieceType structurePieceType, int priority, ResourceLocation textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerJigsawTile(ResourceLocation jigsawPattern, int priority, ResourceLocation tileID, Setter setter) {
        JIGSAW_TO_TILE_MAP.put((Object)jigsawPattern, (Object)new Tuple((Object)tileID, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(tileID, priority);
    }

    public static void registerJigsawTile(ResourceLocation jigsawPattern, int priority, ResourceLocation tileID) {
        StructureHandler.registerJigsawTile(jigsawPattern, priority, tileID, ALWAYS);
    }

    public static void registerMarker(ResourceKey<Structure> structureFeature, ResourceLocation markerType, Component name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(structureFeature.location(), (Tuple<ResourceLocation, Component>)new Tuple((Object)markerType, (Object)name));
    }

    private static int getPriority(ResourceLocation structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(Level world, int chunkX, int chunkZ, ResourceLocation textureId) {
        ResourceLocation existingTile = AtlasAPI.getTileAPI().getGlobalTile(world, chunkX, chunkZ);
        if (StructureHandler.getPriority(textureId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.getTileAPI().putGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    private static void resolveJigsaw(StructurePiece jigsawPiece, ServerLevel world) {
        PoolElementStructurePiece pool;
        StructurePoolElement structurePoolElement;
        if (jigsawPiece instanceof PoolElementStructurePiece && (structurePoolElement = (pool = (PoolElementStructurePiece)jigsawPiece).getElement()) instanceof SinglePoolElement) {
            SinglePoolElement singlePoolElement = (SinglePoolElement)structurePoolElement;
            Optional left = singlePoolElement.template.left();
            if (left.isPresent()) {
                for (Tuple entry : JIGSAW_TO_TILE_MAP.get((Object)((ResourceLocation)left.get()))) {
                    ResourceLocation tile = (ResourceLocation)entry.getA();
                    Setter setter = (Setter)entry.getB();
                    for (ChunkPos pos : setter.matches((Level)world, (StructurePoolElement)singlePoolElement, pool.getBoundingBox(), jigsawPiece)) {
                        StructureHandler.put((Level)world, pos.x, pos.z, tile);
                    }
                }
            }
        }
    }

    public static void resolve(StructurePiece structurePiece, ServerLevel world) {
        if (structurePiece.getType() == StructurePieceType.JIGSAW) {
            StructureHandler.resolveJigsaw(structurePiece, world);
            return;
        }
        ResourceLocation structurePieceId = world.registryAccess().registryOrThrow(Registries.STRUCTURE_PIECE).getKey((Object)structurePiece.getType());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (Tuple entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<ChunkPos> matches;
                if (structurePiece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece pool = (PoolElementStructurePiece)structurePiece;
                    matches = ((Setter)entry.getB()).matches((Level)world, pool.getElement(), pool.getBoundingBox(), structurePiece);
                } else {
                    matches = ((Setter)entry.getB()).matches((Level)world, null, structurePiece.getBoundingBox(), structurePiece);
                }
                for (ChunkPos pos : matches) {
                    StructureHandler.put((Level)world, pos.x, pos.z, (ResourceLocation)entry.getA());
                }
            }
        }
    }

    public static void resolve(StructureStart structureStart, ServerLevel world) {
        ResourceLocation structureId = world.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)structureStart.getStructure());
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            Triple key = Triple.of((Object)structureStart.getBoundingBox().getCenter().getX(), (Object)structureStart.getBoundingBox().getCenter().getY(), (Object)structureId);
            if (VISITED_STRUCTURES.contains(key)) {
                return;
            }
            VISITED_STRUCTURES.add((Triple<Integer, Integer, ResourceLocation>)key);
            AtlasAPI.getMarkerAPI().putGlobalMarker((Level)world, false, (ResourceLocation)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).getA(), (Component)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).getB(), structureStart.getBoundingBox().getCenter().getX(), structureStart.getBoundingBox().getCenter().getZ());
        }
    }

    static interface Setter {
        public Collection<ChunkPos> matches(Level var1, StructurePoolElement var2, BoundingBox var3, StructurePiece var4);
    }
}

