/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.util;

import hunternif.mc.impl.atlas.util.Log;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

class RenderedImageScanned
implements RenderedImage {
    private final int width;
    private final int height;
    private int bufY;
    private final BufferedImage scanBuffer;
    private final Consumer<Graphics2D> generator;
    private final IntConsumer rowListener;

    public RenderedImageScanned(int width, int height, BufferedImage scanBuffer, Consumer<Graphics2D> generator, IntConsumer rowListener) {
        this.width = width;
        this.height = height;
        this.scanBuffer = scanBuffer;
        this.generator = generator;
        this.rowListener = rowListener;
        this.bufY = 0;
        this.redrawToBuffer();
    }

    private void redrawToBuffer() {
        Log.info("Redrawing at %d", this.bufY);
        Graphics2D graphics = this.scanBuffer.createGraphics();
        graphics.setBackground(new Color(0, 0, 0, 0));
        graphics.clearRect(0, 0, this.scanBuffer.getWidth(), this.scanBuffer.getHeight());
        graphics.translate(0, -this.bufY);
        this.generator.accept(graphics);
    }

    @Override
    public Raster getData(Rectangle rect) {
        if (rect.height > this.scanBuffer.getHeight()) {
            return null;
        }
        if (rect.y >= this.bufY + this.scanBuffer.getHeight() || rect.y + rect.height <= this.bufY) {
            this.bufY = rect.y;
            this.redrawToBuffer();
        }
        this.rowListener.accept(rect.y - this.bufY);
        Raster r = this.scanBuffer.getData(new Rectangle(rect.x, rect.y - this.bufY, rect.width, rect.height));
        r = r.createTranslatedChild(r.getMinX(), r.getMinY() + this.bufY);
        return r;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public Object getProperty(String name) {
        return this.scanBuffer.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.scanBuffer.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.scanBuffer.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.scanBuffer.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return (int)Math.ceil((float)this.height / (float)this.scanBuffer.getHeight());
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getTileWidth() {
        return this.width;
    }

    @Override
    public int getTileHeight() {
        return this.height;
    }

    @Override
    public int getTileGridXOffset() {
        return 0;
    }

    @Override
    public int getTileGridYOffset() {
        return 0;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return null;
    }

    @Override
    public Raster getData() {
        return null;
    }

    @Override
    public WritableRaster copyData(WritableRaster raster) {
        return null;
    }
}

