/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.spark.Spark;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.registry.TFMGMobEffects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class DryIceFlake
extends Spark {
    public DryIceFlake(EntityType<? extends Spark> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHit) {
        Entity owner;
        if (!this.level().isClientSide && !((owner = this.getOwner()) instanceof Mob)) {
            BlockPos hitBlockPos = blockHit.getBlockPos().relative(blockHit.getDirection());
            AABB extinguisRadius = new AABB(hitBlockPos);
            extinguisRadius = extinguisRadius.inflate((double)((Integer)TFMGConfigs.common().machines.fireExtinguisherClearRadius.get()).intValue());
            Stream positions = BlockPos.betweenClosedStream((AABB)extinguisRadius);
            positions.forEach(p -> {
                BlockState state = this.level().getBlockState(p);
                if (state.getBlock() instanceof BaseFireBlock) {
                    this.level().setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
                }
            });
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHit) {
        if (!this.level().isClientSide) {
            Entity hitEntity = entityHit.getEntity();
            hitEntity.extinguishFire();
            if (hitEntity.canFreeze()) {
                int currentFreeze = hitEntity.getTicksFrozen();
                int freezeIncrement = 10;
                int newFreeze = Math.min(currentFreeze + freezeIncrement, hitEntity.getTicksRequiredToFreeze() + 20);
                hitEntity.setTicksFrozen(newFreeze);
                if (newFreeze >= hitEntity.getTicksRequiredToFreeze()) {
                    hitEntity.hurt(this.damageSources().freeze(), 2.0f);
                }
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)hitEntity;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 2, false, false, true));
                    livingEntity.removeEffect(TFMGMobEffects.HELLFIRE);
                }
            }
        }
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public ResourceLocation getTexture() {
        return TFMG.asResource("textures/entity/dry_ice_flake.png");
    }

    @Override
    public ParticleOptions getTrailParticle() {
        return ParticleTypes.SNOWFLAKE;
    }
}

