/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cables;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePos;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CableConnectorRenderer
extends SafeBlockEntityRenderer<CableConnectorBlockEntity> {
    public CableConnectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CableConnectorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        this.renderPlayerHeldCable(be, ms, bufferSource, partialTicks);
        LocalPlayer player = Minecraft.getInstance().player;
        for (CableConnection connection : be.connections) {
            if (!connection.visible) continue;
            TFMGUtils.renderWire(be.getLevel(), ms, bufferSource, connection.pos2, connection.pos1, connection.getLength() / 4500.0f, new Color(connection.type.getColor()).getRed(), new Color(connection.type.getColor()).getGreen(), new Color(connection.type.getColor()).getBlue());
        }
    }

    public void renderPlayerHeldCable(CableConnectorBlockEntity be, PoseStack ms, MultiBufferSource bufferSource, float partialTicks) {
        ItemStack stack;
        if (be.player == null) {
            return;
        }
        Player player = be.player;
        if (player.getInventory().contains(TFMGTags.TFMGItemTags.SPOOLS.tag) && (Long)(stack = player.getMainHandItem()).get(TFMGDataComponents.POSITION) != 0L) {
            CablePos position = new CablePos(((Integer)stack.get(TFMGDataComponents.X_POS)).intValue(), ((Integer)stack.get(TFMGDataComponents.Y_POS)).intValue(), ((Integer)stack.get(TFMGDataComponents.Z_POS)).intValue());
            BlockPos pos = BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION)));
            if (pos.equals((Object)be.getBlockPos())) {
                TFMGUtils.renderWire(be.getLevel(), ms, bufferSource, new CablePos(be.wireMovementX.getValue(partialTicks), be.wireMovementY.getValue(partialTicks), be.wireMovementZ.getValue(partialTicks)), position, 1.0E-4f, new Color(be.color).getRed(), new Color(be.color).getGreen(), new Color(be.color).getBlue());
            }
        }
    }
}

