/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.copycat_cable;

import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CopycatCableBlockModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatCableBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        BlockState material = CopycatCableBlockModel.getMaterial(blockEntityData);
        if (material == null) {
            return builder;
        }
        return super.gatherModelData(builder, world, pos, state, blockEntityData);
    }

    @Nullable
    public static BlockState getMaterial(ModelData data) {
        BlockState material = data == null ? null : (BlockState)data.get(MATERIAL_PROPERTY);
        return material == null ? TFMGBlocks.COPYCAT_CABLE_BASE.getDefaultState() : material;
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction facing = Direction.UP;
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        Object specialCopycatModelState = null;
        if (CopycatSpecialCases.isTrapdoorMaterial((BlockState)material)) {
            return blockRenderer.getBlockModel(material).getQuads(state, side, rand, wrappedData, renderType);
        }
        BakedModel model = CopycatCableBlockModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        Vec3 normalScaled16 = normal.scale(0.5);
        for (boolean front : Iterate.trueAndFalse) {
            Vec3 normalScaledN13 = normal.scale(front ? 0.0 : 0.0);
            float contract = 8.0f;
            AABB bb = CUBE_AABB.contract(normal.x * (double)contract / 16.0, normal.y * (double)contract / 16.0, normal.z * (double)contract / 16.0);
            if (!front) {
                bb = bb.move(normalScaled16);
            }
            for (BakedQuad quad : templateQuads) {
                Direction direction = quad.getDirection();
                if (front && direction == facing || !front && direction == facing.getOpposite()) continue;
                quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb, (Vec3)normalScaledN13)));
            }
        }
        return quads;
    }
}

