/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.lights.neon_tube;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.connection.cables.SimplePos;
import com.drmangotea.tfmg.content.electricity.lights.LightBulbBlock;
import com.drmangotea.tfmg.content.electricity.lights.neon_tube.NeonTubeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class NeonTubeBlock
extends PipeBlock
implements IBE<NeonTubeBlockEntity>,
IWrenchable {
    public static final IntegerProperty LIGHT = LightBulbBlock.LIGHT;
    public static final MapCodec<NeonTubeBlock> CODEC = NeonTubeBlock.simpleCodec(NeonTubeBlock::new);

    public NeonTubeBlock(BlockBehaviour.Properties p_55160_) {
        super(0.125f, p_55160_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_51709_) {
        return this.getStateForPlacement((BlockGetter)p_51709_.getLevel(), p_51709_.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter p_51711_, BlockPos p_51712_) {
        BlockState blockstate = p_51711_.getBlockState(p_51712_.below());
        BlockState blockstate1 = p_51711_.getBlockState(p_51712_.above());
        BlockState blockstate2 = p_51711_.getBlockState(p_51712_.north());
        BlockState blockstate3 = p_51711_.getBlockState(p_51712_.east());
        BlockState blockstate4 = p_51711_.getBlockState(p_51712_.south());
        BlockState blockstate5 = p_51711_.getBlockState(p_51712_.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(blockstate.is((Block)this) || blockstate.is(Blocks.CHORUS_FLOWER) || blockstate.is(Blocks.END_STONE)))).setValue((Property)UP, (Comparable)Boolean.valueOf(blockstate1.is((Block)this) || blockstate1.is(Blocks.CHORUS_FLOWER)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(blockstate2.is((Block)this) || blockstate2.is(Blocks.CHORUS_FLOWER)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(blockstate3.is((Block)this) || blockstate3.is(Blocks.CHORUS_FLOWER)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(blockstate4.is((Block)this) || blockstate4.is(Blocks.CHORUS_FLOWER)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(blockstate5.is((Block)this) || blockstate5.is(Blocks.CHORUS_FLOWER)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51735_) {
        p_51735_.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, LIGHT});
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Vec3 position = context.getClickLocation();
        SimplePos clickPosition = new SimplePos(position.x() - (double)pos.getX(), position.y() - (double)pos.getY(), position.z() - (double)pos.getZ());
        Direction dirToToggle = Direction.NORTH;
        if (clickPosition.x() >= 0.375 && clickPosition.x() <= 0.625 && clickPosition.y() >= 0.375 && clickPosition.y() <= 0.625 && clickPosition.z() >= 0.375 && clickPosition.z() <= 0.625) {
            dirToToggle = facing;
        }
        if (clickPosition.x() > 0.625) {
            dirToToggle = Direction.EAST;
        }
        if (clickPosition.x() < 0.375) {
            dirToToggle = Direction.WEST;
        }
        if (clickPosition.y() > 0.625) {
            dirToToggle = Direction.UP;
        }
        if (clickPosition.y() < 0.375) {
            dirToToggle = Direction.DOWN;
        }
        if (clickPosition.z() > 0.625) {
            dirToToggle = Direction.SOUTH;
        }
        if (clickPosition.z() < 0.375) {
            dirToToggle = Direction.NORTH;
        }
        switch (dirToToggle) {
            case UP: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)UP) == false)));
                break;
            }
            case DOWN: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)DOWN) == false)));
                break;
            }
            case WEST: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)WEST) == false)));
                break;
            }
            case EAST: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)EAST) == false)));
                break;
            }
            case NORTH: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)NORTH) == false)));
                break;
            }
            case SOUTH: {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SOUTH) == false)));
            }
        }
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
            if (!(blockEntity instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            be.onPlaced();
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack heldItem = player.getItemInHand(pHand);
        NeonTubeBlockEntity be = (NeonTubeBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (be != null && dye != null) {
            level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            be.setColor(dye);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        if (!p_60569_.is((Block)TFMGBlocks.NEON_TUBE.get())) {
            for (Direction facing : Direction.values()) {
                BlockState neighbourState = level.getBlockState(pos.relative(facing));
                if (!neighbourState.is((Block)TFMGBlocks.NEON_TUBE.get())) continue;
                level.setBlockAndUpdate(pos.relative(facing), (BlockState)neighbourState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(facing.getOpposite()), (Comparable)Boolean.valueOf(true)));
            }
        }
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
        super.onPlace(state, level, pos, p_60569_, p_60570_);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<NeonTubeBlockEntity> getBlockEntityClass() {
        return NeonTubeBlockEntity.class;
    }

    public BlockEntityType<? extends NeonTubeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.NEON_TUBE.get();
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }
}

