/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.segmented_display;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.utilities.segmented_display.SegmentedDisplayBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.IBE;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SegmentedDisplayBlock
extends TFMGHorizontalDirectionalBlock
implements IBE<SegmentedDisplayBlockEntity> {
    public SegmentedDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public static void walkParts(LevelAccessor world, BlockPos start, BiConsumer<BlockPos, Integer> callback) {
        BlockPos nextPos;
        BlockState state = world.getBlockState(start);
        if (!(state.getBlock() instanceof SegmentedDisplayBlock)) {
            return;
        }
        BlockPos currentPos = start;
        Direction left = ((Direction)state.getValue((Property)FACING)).getClockWise();
        Direction right = left.getOpposite();
        while (SegmentedDisplayBlock.areDisplaysEqual(world.getBlockState(nextPos = currentPos.relative(left)), state)) {
            currentPos = nextPos;
        }
        int index = 0;
        while (true) {
            int rowPosition = index++;
            callback.accept(currentPos, rowPosition);
            BlockPos nextPos2 = currentPos.relative(right);
            if (!SegmentedDisplayBlock.areDisplaysEqual(world.getBlockState(nextPos2), state)) break;
            currentPos = nextPos2;
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        String tagElement;
        ItemStack heldItem = player.getItemInHand(hand);
        SegmentedDisplayBlockEntity segmentedDisplay = (SegmentedDisplayBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (heldItem.isEmpty()) {
            segmentedDisplay.clearCustomText();
            return ItemInteractionResult.SUCCESS;
        }
        boolean display = heldItem.getItem() == Items.NAME_TAG && heldItem.has(DataComponents.CUSTOM_NAME) || AllBlocks.CLIPBOARD.isIn(heldItem);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (dye != null) {
            SegmentedDisplayBlock.walkParts((LevelAccessor)world, pos, (currentPos, rowPosition) -> {
                world.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.setColor(dye));
            });
            return ItemInteractionResult.SUCCESS;
        }
        if (!display) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        String tagUsed = tagElement = ((Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.empty())).getString();
        SegmentedDisplayBlock.walkParts((LevelAccessor)world, pos, (currentPos, rowPosition) -> {
            if (display) {
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.displayCustomText(tagUsed, (int)rowPosition));
            }
        });
        return ItemInteractionResult.SUCCESS;
    }

    public static boolean areDisplaysEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.getBlock() instanceof SegmentedDisplayBlock)) {
            return false;
        }
        return otherState.getBlock() instanceof SegmentedDisplayBlock;
    }

    public Class<SegmentedDisplayBlockEntity> getBlockEntityClass() {
        return SegmentedDisplayBlockEntity.class;
    }

    public BlockEntityType<? extends SegmentedDisplayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.SEGMENTED_DISPLAY.get();
    }
}

