/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.traffic_light;

import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.traffic_light.TimerScrollBehaviour;
import com.drmangotea.tfmg.content.electricity.utilities.traffic_light.TrafficLightScrollSlot;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficLightBlockEntity
extends ElectricBlockEntity {
    protected ScrollValueBehaviour timerLength;
    public LerpedFloat glow = LerpedFloat.linear();
    int light = 0;
    public int timer = 180;

    public TrafficLightBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.timerLength = new TimerScrollBehaviour((Component)TFMGLang.translateDirect("traffic_light.timer", new Object[0]), this, new TrafficLightScrollSlot()).between(180, 72000);
        this.timerLength.withFormatter(this::format);
        this.timerLength.withCallback(value -> {
            this.timer = value;
        });
        this.timerLength.setValue(2);
        behaviours.add((BlockEntityBehaviour)this.timerLength);
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.getAxis().isVertical();
    }

    @Override
    public float resistance() {
        return 175.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
        }
        this.glow.chase(200.0, 0.4, LerpedFloat.Chaser.EXP);
        int halfTimer = this.timerLength.getValue() / 2;
        this.light = this.timer < halfTimer - 30 && this.timer > 60 ? 0 : (this.timer > halfTimer + 30 ? 2 : 1);
        if (this.timer == 0) {
            this.glow.setValue(0.0);
            this.timer = this.timerLength.getValue();
        }
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.timer = compound.getInt("Timer");
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Timer", this.timer);
    }
}

