/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerClientHandler;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerMenu;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.TransmissionUpgrade;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class EngineControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
MenuProvider {
    private UUID user;
    private UUID prevUser;
    private boolean deactivatedThisTick;
    public TransmissionUpgrade.TransmissionState shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
    public int accelerationRate = 0;
    public AbstractSmallEngineBlockEntity engine = null;
    public BlockPos enginePos = null;
    public boolean engineStarted = false;
    public boolean clutch = false;
    public boolean brake = false;
    public boolean gas = false;
    public ItemStackHandler frequencyItems = new ItemStackHandler(6);
    public LerpedFloat transmissionLeverAngle = LerpedFloat.angular();
    public LerpedFloat steeringWheelAngle = LerpedFloat.angular();
    public LerpedFloat clutchPedalMotion = LerpedFloat.linear();
    public LerpedFloat gasPedalMotion = LerpedFloat.linear();
    public LerpedFloat brakePedalMotion = LerpedFloat.linear();
    public LerpedFloat fuelDial = LerpedFloat.angular();
    public LerpedFloat rpmDial = LerpedFloat.angular();

    public EngineControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemStack getController() {
        return ItemStack.EMPTY;
    }

    public static Couple<RedstoneLinkNetworkHandler.Frequency> toFrequency(EngineControllerBlockEntity controller, int slot) {
        ItemStackHandler frequencyItems = controller.frequencyItems;
        return Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyItems.getStackInSlot(slot * 2)), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyItems.getStackInSlot(slot * 2 + 1)));
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.enginePos != null) {
            compound.putLong("EnginePos", this.enginePos.asLong());
        }
        compound.putString("Shift", this.shift.name());
        compound.putBoolean("EngineStarted", this.engineStarted);
        compound.put("FrequencyItems", (Tag)this.frequencyItems.serializeNBT(registries));
        if (this.user != null) {
            compound.putUUID("User", this.user);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.enginePos = BlockPos.of((long)compound.getLong("EnginePos"));
        this.engineStarted = compound.getBoolean("EngineStarted");
        if (this.engineStarted && this.accelerationRate == 0) {
            this.accelerationRate = 4;
        }
        this.frequencyItems.deserializeNBT(registries, compound.getCompound("FrequencyItems"));
        this.shift = TransmissionUpgrade.TransmissionState.valueOf(compound.getString("Shift"));
        this.user = compound.hasUUID("User") ? compound.getUUID("User") : null;
        this.updateEngine();
    }

    public void shiftForward() {
        int max = TransmissionUpgrade.TransmissionState.values().length - 1;
        for (int i = 0; i < max; ++i) {
            TransmissionUpgrade.TransmissionState state = TransmissionUpgrade.TransmissionState.values()[i];
            if (state != this.shift || i + 1 > max) continue;
            this.shift = TransmissionUpgrade.TransmissionState.values()[i + 1];
            this.updateShift();
            break;
        }
        this.sendData();
        this.setChanged();
    }

    public void updateShift() {
        BlockEntity blockEntity;
        if (this.enginePos != null && (blockEntity = this.level.getBlockEntity(this.enginePos)) instanceof AbstractSmallEngineBlockEntity) {
            BlockEntity blockEntity2;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            be.getControllerBE().shift = this.shift;
            be.getControllerBE().clutchPressed = this.clutch;
            be.getControllerBE().updateGeneratedRotation();
            if (be.getControllerBE().engineLength() > 1 && (blockEntity2 = this.level.getBlockEntity(BlockPos.of((long)be.getControllerBE().engines.get(be.getControllerBE().engineLength() - 1)))) instanceof AbstractSmallEngineBlockEntity) {
                AbstractSmallEngineBlockEntity be2 = (AbstractSmallEngineBlockEntity)blockEntity2;
                be2.updateGeneratedRotation();
            }
        }
    }

    public void destroy() {
        super.destroy();
        Entity playerEntity = ((ServerLevel)this.level).getEntity(this.user);
        if (playerEntity instanceof Player) {
            this.stopUsing((Player)playerEntity);
        }
    }

    public void shiftBack() {
        int max = TransmissionUpgrade.TransmissionState.values().length;
        for (int i = 0; i < max; ++i) {
            TransmissionUpgrade.TransmissionState state = TransmissionUpgrade.TransmissionState.values()[i];
            if (state != this.shift || i - 1 < 0) continue;
            this.shift = TransmissionUpgrade.TransmissionState.values()[i - 1];
            this.updateShift();
            break;
        }
    }

    public void tickAcceleration() {
        if (this.gas) {
            if (this.engineStarted && this.accelerationRate < 15) {
                ++this.accelerationRate;
                this.updateEngine();
            }
        } else if (!(this.accelerationRate <= 4 && this.engineStarted || this.accelerationRate <= 0)) {
            --this.accelerationRate;
            this.updateEngine();
        }
    }

    public void tickBraking() {
        if (this.brake && this.accelerationRate > 4) {
            --this.accelerationRate;
            this.updateEngine();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.tickAcceleration();
    }

    public static ItemStackHandler getFrequencyItems(EngineControllerBlockEntity be) {
        return be.frequencyItems;
    }

    public void handleInput(Collection<Integer> currentlyPressed, boolean press) {
        if (currentlyPressed.contains(4)) {
            this.clutch = press;
            this.sendData();
            this.setChanged();
        }
        if (currentlyPressed.contains(0)) {
            this.gas = press;
            this.sendData();
            this.setChanged();
        }
        if (currentlyPressed.contains(1)) {
            this.brake = press;
            this.sendData();
            this.setChanged();
        }
    }

    public void toggleEngine() {
        this.engineStarted = !this.engineStarted;
        this.accelerationRate = this.engineStarted ? 4 : 0;
        this.updateEngine();
        this.sendData();
        this.setChanged();
    }

    public void remove() {
        super.remove();
        this.disconnectEngine();
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.level.isClientSide) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::tryToggleActive);
            this.prevUser = this.user;
            this.tickRendering();
        }
        if (this.enginePos != null && this.engine == null && (blockEntity = this.level.getBlockEntity(this.enginePos)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be;
            this.engine = be = (AbstractSmallEngineBlockEntity)blockEntity;
            this.engine.getControllerBE().highestSignal = 0.0f;
        }
        this.tickBraking();
        if (!this.level.isClientSide) {
            this.deactivatedThisTick = false;
            if (!(this.level instanceof ServerLevel)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            Entity entity = ((ServerLevel)this.level).getEntity(this.user);
            if (!(entity instanceof Player)) {
                this.stopUsing(null);
                return;
            }
            Player player = (Player)entity;
            if (!EngineControllerBlockEntity.playerInRange(player, this.level, this.worldPosition) || !EngineControllerBlockEntity.playerIsUsingEngineController(player)) {
                this.stopUsing(player);
            }
        }
    }

    public void updateEngine() {
        if (this.engine == null) {
            return;
        }
        this.engine.getControllerBE().engineController = this.getBlockPos();
        this.engine.getControllerBE().highestSignal = this.accelerationRate / 15;
        this.engine.getControllerBE().updateRotation();
    }

    public void disconnectEngine() {
        if (this.engine == null) {
            return;
        }
        this.engine.getControllerBE().highestSignal = 0.0f;
        this.engine.getControllerBE().engineController = null;
        this.engine.getControllerBE().updateGeneratedRotation();
    }

    public void tickRendering() {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        this.steeringWheelAngle.chase(this.isPressed(2) ? -40.0 : (this.isPressed(3) ? 40.0 : 0.0), 0.25, LerpedFloat.Chaser.EXP);
        this.clutchPedalMotion.chase(this.isPressed(4) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.gasPedalMotion.chase(this.isPressed(0) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.brakePedalMotion.chase(this.isPressed(1) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.transmissionLeverAngle.chase(this.shift == TransmissionUpgrade.TransmissionState.REVERSE ? -20.0 : (double)(this.shift.value * 20.0f), 0.25, LerpedFloat.Chaser.EXP);
        this.fuelDial.chase(this.engine == null ? 0.0 : (double)this.engine.getControllerBE().fuelTank.getFluidAmount() / (double)this.engine.fuelTank.getCapacity() * 180.0, 0.25, LerpedFloat.Chaser.EXP);
        this.rpmDial.chase(this.engine == null ? 0.0 : (double)this.engine.getControllerBE().rpm / 6000.0 * 180.0, 0.25, LerpedFloat.Chaser.EXP);
        this.transmissionLeverAngle.tickChaser();
        this.steeringWheelAngle.tickChaser();
        this.clutchPedalMotion.tickChaser();
        this.gasPedalMotion.tickChaser();
        this.brakePedalMotion.tickChaser();
        this.fuelDial.tickChaser();
        this.rpmDial.tickChaser();
    }

    public boolean isPressed(int id) {
        return EngineControllerClientHandler.currentlyPressed.contains(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tryToggleActive() {
        if (this.user == null && Minecraft.getInstance().player.getUUID().equals(this.prevUser)) {
            EngineControllerClientHandler.deactivateInLectern();
        } else if (this.prevUser == null && Minecraft.getInstance().player.getUUID().equals(this.user)) {
            EngineControllerClientHandler.activateInLectern(this.worldPosition);
        }
    }

    public void tryStopUsing(Player player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    public static boolean playerIsUsingEngineController(Player player) {
        return player.getPersistentData().contains("IsUsingEngineController");
    }

    public void tryStartUsing(Player player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !EngineControllerBlockEntity.playerIsUsingEngineController(player) && EngineControllerBlockEntity.playerInRange(player, this.level, this.worldPosition)) {
            this.startUsing(player);
        }
    }

    private void startUsing(Player player) {
        this.user = player.getUUID();
        player.getPersistentData().putBoolean("IsUsingEngineController", true);
        this.sendData();
    }

    private void stopUsing(Player player) {
        this.user = null;
        if (player != null) {
            player.getPersistentData().remove("IsUsingEngineController");
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public InteractionResult use(Player player) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (this.level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)this, this.getBlockPos());
        return InteractionResult.SUCCESS;
    }

    public boolean isUsedBy(Player player) {
        return this.hasUser() && this.user.equals(player.getUUID());
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 0.4 * player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        return player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < reach * reach;
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return EngineControllerMenu.create(pContainerId, pPlayerInventory, this);
    }
}

