/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.engines.base.AbstractEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.base.EngineBlock;
import com.drmangotea.tfmg.content.engines.base.EngineComponentsInventory;
import com.drmangotea.tfmg.content.engines.base.EngineProperties;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.EnginePipingUpgrade;
import com.drmangotea.tfmg.content.engines.upgrades.EngineUpgrade;
import com.drmangotea.tfmg.content.engines.upgrades.TransmissionUpgrade;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class AbstractSmallEngineBlockEntity
extends AbstractEngineBlockEntity {
    public Optional<? extends EngineUpgrade> upgrade = Optional.empty();
    public TransmissionUpgrade.TransmissionState shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
    public boolean clutchPressed = false;
    public int oil = 0;
    public int coolingFluid = 0;
    public EngineComponentsInventory componentsInventory;
    public BlockPos controller = this.getBlockPos();
    public boolean connectNextTick = true;
    public boolean delayedConnect = false;
    public List<Long> engines = new ArrayList<Long>();
    public int engineNumber = 0;

    public AbstractSmallEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.componentsInventory = new EngineComponentsInventory((SyncedBlockEntity)this, EngineProperties.commonRegularComponents());
    }

    @Override
    public int getFuelConsumption() {
        if (this.rpm == 0.0f) {
            return 0;
        }
        float oilModifier = this.oil > 0 ? 0.7f : 1.0f;
        float coolingFluidModifier = this.coolingFluid > 0 ? 0.7f : 1.0f;
        return (int)(12.5f * (1.0f / this.efficiencyModifier()) * this.getSpeedEfficiency() * this.highestSignal / 15.0f * oilModifier * coolingFluidModifier) * (this.engineLength() + 1);
    }

    public void detashEngines() {
    }

    public void setBlockStates(AbstractSmallEngineBlockEntity be, BlockPos last) {
        if (!be.isController()) {
            this.level.setBlock(be.getBlockPos(), (BlockState)this.level.getBlockState(be.getBlockPos()).setValue(EngineBlock.SHAFT_FACING, (Comparable)((Direction)this.getBlockState().getValue(EngineBlock.SHAFT_FACING)).getOpposite()), 2);
        }
    }

    public boolean hasAllComponents() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            return be.nextComponent() == Ingredient.EMPTY;
        }
        return false;
    }

    public boolean hasUpgrade() {
        return this.upgrade.isPresent();
    }

    @Override
    public int voltageGeneration() {
        if (this.upgrade.isPresent() && this.upgrade.get().getItem() == TFMGBlocks.GENERATOR.asItem()) {
            return (int)(20.0f * (this.rpm / 500.0f));
        }
        return 0;
    }

    @Override
    public int powerGeneration() {
        if (this.upgrade.isPresent() && this.upgrade.get().getItem() == TFMGBlocks.GENERATOR.asItem()) {
            return (int)this.rpm;
        }
        return 0;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.upgrade.ifPresent(engineUpgrade -> engineUpgrade.lazyTickUpgrade(this));
        if (!this.canWork()) {
            return;
        }
        if (this.rpm == 0.0f) {
            return;
        }
        if (this.level.random.nextInt(45) == 0 && this.oil > 0) {
            --this.oil;
        }
        if (this.level.random.nextInt(45) == 0 && this.coolingFluid > 0) {
            --this.coolingFluid;
        }
    }

    public float calculateAddedStressCapacity() {
        float stress = super.calculateAddedStressCapacity() + this.torque;
        return this.hasTwoShafts() ? stress / 2.0f : stress;
    }

    public boolean hasTwoShafts() {
        BlockPos pos;
        if (!this.isController()) {
            return this.getControllerBE().hasTwoShafts();
        }
        return this.getBlockState().getValue(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT && this.level.getBlockState(pos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue(EngineBlock.SHAFT_FACING)).getOpposite(), this.engineLength())).getValue(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT;
    }

    @Override
    public void neighbourChanged() {
        if (this.controller == null) {
            return;
        }
        super.neighbourChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (this.hasUpgrade() && this.upgrade.get().getItem() == TFMGBlocks.INDUSTRIAL_PIPE.asItem()) {
            ((EnginePipingUpgrade)this.upgrade.get()).findTank(this);
        }
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putLong("Controller", this.controller.asLong());
        compound.putString("Shift", this.shift.name());
        if (this.controller != null) {
            compound.putLong("ControllerPos", this.controller.asLong());
        } else {
            compound.remove("ControllerPos");
        }
        if (this.upgrade.isPresent()) {
            compound.put("UpgradeItem", this.upgrade.get().getItem().getDefaultInstance().saveOptional(registries));
        }
        compound.put("Components", (Tag)this.componentsInventory.serializeNBT(registries));
        compound.putInt("Oil", this.oil);
        compound.putInt("CoolingFluid", this.coolingFluid);
        super.write(compound, registries, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (compound.contains("UpgradeItem") && ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("UpgradeItem")).isPresent()) {
            ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("UpgradeItem")).get();
            this.upgrade = Optional.of(EngineUpgrade.getUpgrades().get(stack.getItem()));
        }
        if (!compound.getString("Shift").isEmpty()) {
            this.shift = TransmissionUpgrade.TransmissionState.valueOf(compound.getString("Shift"));
        }
        this.oil = compound.getInt("Oil");
        this.coolingFluid = compound.getInt("CoolingFluid");
        this.componentsInventory.deserializeNBT(registries, compound.getCompound("Components"));
        super.read(compound, registries, clientPacket);
        this.controller = BlockPos.of((long)compound.getLong("Controller"));
    }

    public int engineLength() {
        return this.engines.size();
    }

    @Override
    public boolean canWork() {
        if (!this.nextComponent().isEmpty()) {
            return false;
        }
        return super.canWork();
    }

    public Ingredient nextComponent() {
        if (!this.isController()) {
            return Ingredient.EMPTY;
        }
        for (int i = 0; i < this.componentsInventory.getSlots(); ++i) {
            if (!this.componentsInventory.getStackInSlot(i).isEmpty()) continue;
            return this.componentsInventory.components.get(i);
        }
        return Ingredient.EMPTY;
    }

    @Override
    protected void analogSignalChanged() {
        BlockEntity blockEntity;
        int newSignal;
        if (this.controller == null) {
            return;
        }
        if (this.hasEngineController()) {
            return;
        }
        this.getControllerBE().updateRotation();
        this.getControllerBE().updateGeneratedRotation();
        this.signal = newSignal = this.level.getBestNeighborSignal(this.getBlockPos());
        if (!this.isController() && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            be.analogSignalChanged();
            return;
        }
        for (long posLong : this.engines) {
            BlockPos pos = BlockPos.of((long)posLong);
            newSignal = Math.max(this.level.getBestNeighborSignal(pos), newSignal);
        }
        newSignal = Math.max(this.level.getBestNeighborSignal(this.controller), newSignal);
        this.highestSignal = (float)newSignal / 15.0f;
        this.updateRotation();
    }

    @Override
    public IFluidHandler handlerForCapability() {
        return this.isController() || this.getControllerBE() == this ? new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank}) : this.getControllerBE().handlerForCapability();
    }

    @Override
    public void updateRotation() {
        if (!this.isController()) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
            if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
                AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
                be.updateRotation();
            }
            return;
        }
        if (this.fuelTank.isEmpty()) {
            this.rpm = 0.0f;
            this.torque = 0.0f;
        }
        ArrayList<Long> allEngines = new ArrayList<Long>(this.engines);
        allEngines.add(this.controller.asLong());
        for (TagKey<Fluid> fluidTag : this.getSupportedFuels()) {
            if (!this.fuelTank.getFluid().getFluid().is(fluidTag)) continue;
            if (!this.canWork()) {
                allEngines.forEach(l -> {
                    BlockPos pos = BlockPos.of((long)l);
                    BlockEntity patt0$temp = this.level.getBlockEntity(pos);
                    if (patt0$temp instanceof AbstractEngineBlockEntity) {
                        AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt0$temp;
                        be.rpm = 0.0f;
                        be.torque = 0.0f;
                        be.updateGeneratedRotation();
                    }
                });
                return;
            }
            allEngines.forEach(l -> {
                BlockPos pos = BlockPos.of((long)l);
                BlockEntity patt0$temp = this.level.getBlockEntity(pos);
                if (patt0$temp instanceof AbstractEngineBlockEntity) {
                    AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt0$temp;
                    be.rpm = 4000.0f * this.speedModifier() * this.highestSignal;
                    be.torque = 15.0f * this.torqueModifier() * this.highestSignal * (float)this.engineLength();
                    be.updateGeneratedRotation();
                }
            });
            return;
        }
        this.updateGeneratedRotation();
        this.getAllEngines().forEach(l -> {
            BlockEntity patt0$temp;
            if (this.hasLevel() && (patt0$temp = this.level.getBlockEntity(BlockPos.of((long)l))) instanceof AbstractEngineBlockEntity) {
                AbstractEngineBlockEntity be = (AbstractEngineBlockEntity)patt0$temp;
                be.updateGeneratedRotation();
            }
        });
    }

    public boolean canGenerateSpeed() {
        return this.getBlockState().getValue(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.SHAFT;
    }

    public float getGeneratedSpeed() {
        if (!this.canGenerateSpeed()) {
            return 0.0f;
        }
        if (this.hasLevel()) {
            if (this.getControllerBE().fuelTank.isEmpty()) {
                return 0.0f;
            }
            if (!this.getControllerBE().canWork()) {
                return 0.0f;
            }
            float speed = this.rpm / 40.0f;
            if (this.reverse) {
                speed *= -1.0f;
            }
            if (this.getControllerBE().hasEngineController() && this.getControllerBE().hasTwoShafts()) {
                speed = switch (this.getControllerBE().shift) {
                    default -> throw new MatchException(null, null);
                    case TransmissionUpgrade.TransmissionState.REVERSE -> speed * -0.3f;
                    case TransmissionUpgrade.TransmissionState.NEUTRAL -> 0.0f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_1 -> speed * 0.2f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_2 -> speed * 0.4f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_3 -> speed * 0.6f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_4 -> speed * 0.8f;
                    case TransmissionUpgrade.TransmissionState.SHIFT_5 -> speed;
                    case TransmissionUpgrade.TransmissionState.SHIFT_6 -> speed * 1.2f;
                };
            }
            return AbstractSmallEngineBlockEntity.convertToDirection((float)Math.min((int)speed, 256), (Direction)((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)));
        }
        return 0.0f;
    }

    @Override
    public void tankUpdated(FluidStack stack, boolean fuel) {
        if (stack.getFluid().isSame((Fluid)TFMGFluids.CARBON_DIOXIDE.get()) && stack.getAmount() >= this.exhaustTank.getSpace()) {
            this.updateRotation();
        }
        super.tankUpdated(stack, fuel);
    }

    public boolean insertItem(ItemStack itemStack, boolean shifting, Player player, InteractionHand hand) {
        Optional<? extends EngineUpgrade> itemUpgrade;
        BlockEntity toDrain2;
        BlockEntity blockEntity;
        Direction shaft_facing = (Direction)this.getBlockState().getValue(EngineBlock.SHAFT_FACING);
        if (itemStack.is(AllBlocks.SHAFT.asItem()) && this.getBlockState().getValue(EngineBlock.ENGINE_STATE) == EngineBlock.EngineState.NORMAL && !(this.level.getBlockEntity(this.getBlockPos().relative(shaft_facing)) instanceof AbstractEngineBlockEntity)) {
            this.playInsertionSound();
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.SHAFT)), 2);
            itemStack.shrink(1);
            this.updateRotation();
            this.setChanged();
            this.sendData();
            return true;
        }
        if (itemStack.is((Item)TFMGItems.SCREWDRIVER.get())) {
            for (int i = this.componentsInventory.components.size() - 1; i >= 0; --i) {
                if (this.componentsInventory.getItem(i).isEmpty()) continue;
                this.dropItem(this.componentsInventory.getItem(i));
                this.componentsInventory.setStackInSlot(i, ItemStack.EMPTY);
                this.playRemovalSound();
                this.updateRotation();
                this.setChanged();
                this.sendData();
                return true;
            }
        }
        if (itemStack.is((Item)TFMGItems.COOLING_FLUID_BOTTLE.get()) && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            int toDrain2 = Math.min(2000 - this.coolingFluid, (Integer)itemStack.get(TFMGDataComponents.AMOUNT));
            itemStack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)itemStack.get(TFMGDataComponents.AMOUNT) - toDrain2));
            be.coolingFluid += toDrain2;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (itemStack.is((Item)TFMGItems.OIL_CAN.get()) && (toDrain2 = this.level.getBlockEntity(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)toDrain2;
            int toDrain3 = Math.min(2000 - this.oil, (Integer)itemStack.get(TFMGDataComponents.AMOUNT));
            itemStack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)itemStack.get(TFMGDataComponents.AMOUNT) - toDrain3));
            be.oil += toDrain3;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (itemStack.is((Item)TFMGFluids.COOLING_FLUID.getBucket().get()) && this.coolingFluid <= 1000) {
            this.coolingFluid += 1000;
            player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (itemStack.is((Item)TFMGFluids.LUBRICATION_OIL.getBucket().get()) && this.oil <= 1000) {
            this.oil += 1000;
            player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateRotation();
            return true;
        }
        if (this.upgrade.isEmpty() && EngineUpgrade.getUpgrades().containsKey(itemStack.getItem()) && (itemUpgrade = EngineUpgrade.getUpgrades().get(itemStack.getItem()).createUpgrade()).isPresent() && this.isUpgradeFirst(itemUpgrade.get())) {
            BlockPos pos;
            BlockEntity blockEntity2;
            this.upgrade = itemUpgrade;
            this.playInsertionSound();
            this.updateRotation();
            this.upgrade.ifPresent(u -> u.updateUpgrade(this));
            itemStack.shrink(1);
            if (this.upgrade.isPresent() && this.upgrade.get() instanceof TransmissionUpgrade && itemStack.has(TFMGDataComponents.POSITION) && itemStack.get(TFMGDataComponents.POSITION) != null && (blockEntity2 = this.level.getBlockEntity(pos = BlockPos.of((long)((Long)itemStack.get(TFMGDataComponents.POSITION))))) instanceof EngineControllerBlockEntity) {
                EngineControllerBlockEntity engineControllerBE = (EngineControllerBlockEntity)blockEntity2;
                this.getControllerBE().updateGeneratedRotation();
                this.getControllerBE().controller = pos;
                engineControllerBE.enginePos = this.getBlockPos();
                this.getControllerBE().highestSignal = 0.0f;
            }
            this.setChanged();
            this.sendData();
            return true;
        }
        if (!this.isController()) {
            return false;
        }
        if (this.nextComponent().test(itemStack) && this.componentsInventory.insertItem(itemStack)) {
            if (!itemStack.is((Item)TFMGItems.SCREWDRIVER.get())) {
                itemStack.shrink(1);
            }
            this.playInsertionSound();
            this.updateRotation();
            this.setChanged();
            this.sendData();
            return true;
        }
        return false;
    }

    public List<AbstractSmallEngineBlockEntity> getEngines() {
        ArrayList<AbstractSmallEngineBlockEntity> values = new ArrayList<AbstractSmallEngineBlockEntity>();
        for (Long position : this.getAllEngines()) {
            BlockPos pos = BlockPos.of((long)position);
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof AbstractSmallEngineBlockEntity)) continue;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            values.add(be);
        }
        return values;
    }

    public boolean isController() {
        if (this.controller == null) {
            this.controller = this.getBlockPos();
        }
        if (this.engineNumber == 0) {
            this.controller = this.getBlockPos();
        }
        return this.controller.equals((Object)this.getBlockPos());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.controller.asLong() == this.getBlockPos().asLong()) {
            TFMGTexts.header("engine_controller").forGoggles(tooltip);
        }
        TFMGTexts.Engine.shift(this.shift.langKey).forGoggles(tooltip);
        TFMGTexts.Engine.speedEfficiency(this.getSpeedEfficiency()).forGoggles(tooltip);
        TFMGTexts.Engine.efficiency(this.efficiencyModifier()).forGoggles(tooltip);
        TFMGTexts.Engine.fuelConsumption(this.getFuelConsumption()).forGoggles(tooltip);
        TFMGTexts.Engine.rpm(this.rpm).forGoggles(tooltip);
        TFMGTexts.Engine.length(this.engineLength()).forGoggles(tooltip);
        TFMGTexts.Engine.torque(this.torque).forGoggles(tooltip);
        TFMGTexts.Engine.signal((int)(this.highestSignal * 15.0f)).forGoggles(tooltip);
        TFMGLang.number(this.engineNumber).style(ChatFormatting.DARK_GREEN).forGoggles(tooltip);
        if (this.isController() && !this.nextComponent().isEmpty()) {
            TFMGLang.text(this.nextComponent().getItems()[0].getDisplayName().getString()).forGoggles(tooltip);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public boolean isUpgradeFirst(EngineUpgrade itemUpgrade) {
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent() || be.upgrade.get().getItem() != itemUpgrade.getItem()) continue;
            return false;
        }
        return true;
    }

    public List<Long> getAllEngines() {
        ArrayList<Long> list = new ArrayList<Long>(this.engines);
        list.add(this.controller.asLong());
        return list;
    }

    public AbstractSmallEngineBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
            return (AbstractSmallEngineBlockEntity)blockEntity;
        }
        return this;
    }

    @Override
    public void tick() {
        this.upgrade.ifPresent(engineUpgrade -> engineUpgrade.tickUpgrade(this));
        if (this.connectNextTick && this.isController()) {
            this.connect();
            this.connectNextTick = false;
        }
        super.tick();
    }

    public void connect() {
        try {
            AbstractSmallEngineBlockEntity be;
            Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
            Direction updateDirection = facing.getOpposite();
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
            if (blockEntity instanceof AbstractSmallEngineBlockEntity && (be = (AbstractSmallEngineBlockEntity)blockEntity).getBlockState().getBlock() == this.getBlockState().getBlock()) {
                be.connect();
                return;
            }
            this.engines = new ArrayList<Long>();
            for (int i = 0; i < this.getMaxLength(); ++i) {
                BlockPos pos = this.getBlockPos().relative(updateDirection, i);
                BlockEntity blockEntity2 = this.level.getBlockEntity(pos);
                if (blockEntity2 instanceof AbstractSmallEngineBlockEntity) {
                    AbstractSmallEngineBlockEntity be2 = (AbstractSmallEngineBlockEntity)blockEntity2;
                    if (be2.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING) != facing) {
                        return;
                    }
                    this.level.setBlock(be2.getBlockPos(), (BlockState)be2.getBlockState().setValue(EngineBlock.SHAFT_FACING, (Comparable)(be2.getBlockPos() == this.getBlockPos() ? facing : updateDirection)), 2);
                    be2.detashEngines();
                    this.engines.add(pos.asLong());
                    be2.engineNumber = i;
                    be2.engines = new ArrayList<Long>();
                    be2.controller = this.getBlockPos();
                    be2.refreshCapability();
                    this.setBlockStates(be2, null);
                    this.updateGeneratedRotation();
                    this.onUpdated();
                    be2.sendData();
                    be2.setChanged();
                    if (be2.getBlockState().getValue(EngineBlock.ENGINE_STATE) != EngineBlock.EngineState.NORMAL && i != 0) {
                        this.setBlockStates(this, this.getBlockPos().relative(updateDirection, i - 1));
                        break;
                    }
                    if (i != this.getMaxLength() - 1) continue;
                    this.setBlockStates(this, this.getBlockPos().relative(updateDirection, i));
                    continue;
                }
                this.setBlockStates(this, this.getBlockPos().relative(updateDirection, i - 1));
                return;
            }
            this.updateGeneratedRotation();
            this.updateRotation();
            this.setChanged();
            this.sendData();
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.updateOthers();
    }

    public void updateOthers() {
        if (!this.isController()) {
            this.getControllerBE().connectNextTick = true;
        }
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            if (direction.getAxis() != facing.getAxis() || !((blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(direction))) instanceof AbstractSmallEngineBlockEntity)) continue;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            this.level.setBlockAndUpdate(be.getBlockPos(), (BlockState)be.getBlockState().setValue(EngineBlock.SHAFT_FACING, (Comparable)direction.getOpposite()));
            be.delayedConnect = true;
            be.connectNextTick = true;
            be.connect();
        }
    }

    public float getUpgradeSpeedModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getSpeedModifier(this);
        }
        return modifier;
    }

    public float getUpgradeTorqueModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getTorqueModifier(this);
        }
        return modifier;
    }

    public float getUpgradeEfficiencyModifier() {
        float modifier = 1.0f;
        for (AbstractSmallEngineBlockEntity be : this.getEngines()) {
            if (!be.upgrade.isPresent()) continue;
            modifier *= be.upgrade.get().getEfficiencyModifier(this);
        }
        return modifier;
    }
}

