/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.regular_engine;

import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class RegularEngineVisual
extends KineticBlockEntityVisual<AbstractSmallEngineBlockEntity> {
    @Nullable
    protected final RotatingInstance shaft;

    public RegularEngineVisual(VisualizationContext context, AbstractSmallEngineBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        RotatingInstance shaft = null;
        Block block = this.blockState.getBlock();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.rotationAxis())) {
                if (!def.hasShaftTowards((LevelReader)blockEntity.getLevel(), blockEntity.getBlockPos(), this.blockState, d)) continue;
                RotatingInstance instance = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
                instance.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, d).setChanged();
                shaft = instance;
            }
        }
        this.shaft = shaft;
    }

    public void update(float pt) {
        if (this.shaft != null) {
            this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        BlockPos behind = this.pos.relative(Direction.UP);
        if (this.shaft != null) {
            this.relight(behind, new FlatLit[]{this.shaft});
        }
    }

    protected void _delete() {
        if (this.shaft != null) {
            this.shaft.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.shaft);
    }
}

