/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.upgrades;

import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.EngineUpgrade;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GoldenTurboUpgradeData
extends EngineUpgrade {
    LerpedFloat speed = LerpedFloat.linear();
    float angle;

    @Override
    public Optional<? extends EngineUpgrade> createUpgrade() {
        return Optional.of(new GoldenTurboUpgradeData());
    }

    public PartialModel getModel() {
        return TFMGPartialModels.GOLDEN_TURBO;
    }

    @Override
    public void tickUpgrade(AbstractSmallEngineBlockEntity engine) {
        if (!engine.getLevel().isClientSide) {
            return;
        }
        this.speed.chase((double)(engine.rpm / 200.0f), 0.0078125, LerpedFloat.Chaser.EXP);
        this.speed.tickChaser();
    }

    @Override
    public void render(AbstractSmallEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        this.angle += be.rpm / 500.0f;
        this.angle %= 360.0f;
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        boolean side = false;
        ms.pushPose();
        if (be instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity blockEntity = (RegularEngineBlockEntity)be;
            side = blockEntity.type.upgradesOnSide;
        }
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)this.getModel(), (BlockState)state).center()).rotateYDegrees(facing.toYRot())).translateX(side ? -0.25f : 0.0f)).rotateZDegrees(side ? 90.0f : 0.0f)).uncenter()).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)TFMGPartialModels.GOLDEN_TURBO_PROPELLER, (BlockState)state).center()).rotateYDegrees(facing.toYRot())).translateX(side ? -0.25f : 0.0f)).rotateZDegrees(side ? 90.0f : 0.0f)).rotateYDegrees(this.angle)).uncenter()).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ms.popPose();
    }

    @Override
    public float getTorqueModifier(AbstractSmallEngineBlockEntity engine) {
        return 1.4f;
    }

    @Override
    public Item getItem() {
        return TFMGItems.GOLDEN_TURBO.asItem();
    }

    @Override
    public float getSpeedModifier(AbstractSmallEngineBlockEntity engine) {
        return 1.3f;
    }
}

