/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.explosives.napalm;

import com.drmangotea.tfmg.content.items.weapons.explosives.napalm.NapalmBombEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class NapalmBombBlock
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public NapalmBombBlock(BlockBehaviour.Properties p_57422_) {
        super(p_57422_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        NapalmBombBlock.explode(world, pos, igniter);
    }

    public void onPlace(BlockState p_57466_, Level p_57467_, BlockPos p_57468_, BlockState p_57469_, boolean p_57470_) {
        if (!p_57469_.is(p_57466_.getBlock()) && p_57467_.hasNeighborSignal(p_57468_)) {
            this.onCaughtFire(p_57466_, p_57467_, p_57468_, null, null);
            p_57467_.removeBlock(p_57468_, false);
        }
    }

    public void neighborChanged(BlockState p_57457_, Level p_57458_, BlockPos p_57459_, Block p_57460_, BlockPos p_57461_, boolean p_57462_) {
        if (p_57458_.hasNeighborSignal(p_57459_)) {
            this.onCaughtFire(p_57457_, p_57458_, p_57459_, null, null);
            p_57458_.removeBlock(p_57459_, false);
        }
    }

    public BlockState playerWillDestroy(Level p_57445_, BlockPos p_57446_, BlockState p_57447_, Player p_57448_) {
        if (!p_57445_.isClientSide() && !p_57448_.isCreative() && ((Boolean)p_57447_.getValue((Property)UNSTABLE)).booleanValue()) {
            this.onCaughtFire(p_57447_, p_57445_, p_57446_, null, null);
        }
        super.playerWillDestroy(p_57445_, p_57446_, p_57447_, p_57448_);
        return p_57447_;
    }

    public void wasExploded(Level p_57441_, BlockPos p_57442_, Explosion sourceMob) {
        if (!p_57441_.isClientSide) {
            NapalmBombEntity napalmBomb = new NapalmBombEntity(p_57441_, (double)p_57442_.getX() + 0.5, p_57442_.getY(), (double)p_57442_.getZ() + 0.5, sourceMob.getIndirectSourceEntity());
            int i = napalmBomb.getFuse();
            napalmBomb.setFuse((short)(p_57441_.random.nextInt(i / 4) + i / 8));
            p_57441_.addFreshEntity((Entity)napalmBomb);
        }
    }

    @Deprecated
    public static void explode(Level p_57434_, BlockPos p_57435_) {
        NapalmBombBlock.explode(p_57434_, p_57435_, null);
    }

    @Deprecated
    private static void explode(Level p_57437_, BlockPos p_57438_, @Nullable LivingEntity p_57439_) {
        if (!p_57437_.isClientSide) {
            NapalmBombEntity napalmBomb = new NapalmBombEntity(p_57437_, (double)p_57438_.getX() + 0.5, p_57438_.getY(), (double)p_57438_.getZ() + 0.5, p_57439_);
            p_57437_.addFreshEntity((Entity)napalmBomb);
            p_57437_.playSound((Player)null, napalmBomb.getX(), napalmBomb.getY(), napalmBomb.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_57437_.gameEvent((Entity)p_57439_, (Holder)GameEvent.PRIME_FUSE, p_57438_);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!itemstack.is(Items.FLINT_AND_STEEL) && !itemstack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        this.onCaughtFire(state, level, pos, hitResult.getDirection(), (LivingEntity)player);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        Item item = itemstack.getItem();
        if (!player.isCreative()) {
            if (itemstack.is(Items.FLINT_AND_STEEL)) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            } else {
                itemstack.shrink(1);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return ItemInteractionResult.SUCCESS;
    }

    public void onProjectileHit(Level p_57429_, BlockState p_57430_, BlockHitResult p_57431_, Projectile p_57432_) {
        if (!p_57429_.isClientSide) {
            BlockPos blockpos = p_57431_.getBlockPos();
            Entity entity = p_57432_.getOwner();
            if (p_57432_.isOnFire() && p_57432_.mayInteract(p_57429_, blockpos)) {
                this.onCaughtFire(p_57430_, p_57429_, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                p_57429_.removeBlock(blockpos, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion p_57427_) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57464_) {
        p_57464_.add(new Property[]{UNSTABLE});
    }
}

