/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.fire;

import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.fire.TFMGColoredFires;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GreenFireBlock
extends BaseFireBlock {
    public static final MapCodec<GreenFireBlock> CODEC = GreenFireBlock.simpleCodec(GreenFireBlock::new);
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();

    public GreenFireBlock(BlockBehaviour.Properties p_53425_) {
        super(p_53425_, 1.0f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(p_53497_ -> (Integer)p_53497_.getValue((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), GreenFireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)p_53491_.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? DOWN_AABB : voxelshape;
    }

    public BlockState updateShape(BlockState p_53458_, Direction p_53459_, BlockState p_53460_, LevelAccessor p_53461_, BlockPos p_53462_, BlockPos p_53463_) {
        return this.canSurvive(p_53458_, (LevelReader)p_53461_, p_53462_) ? this.getStateWithAge(p_53461_, p_53462_, (Integer)p_53458_.getValue((Property)AGE)) : Blocks.AIR.defaultBlockState();
    }

    public VoxelShape getShape(BlockState p_53474_, BlockGetter p_53475_, BlockPos p_53476_, CollisionContext p_53477_) {
        return this.shapesCache.get(p_53474_.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_53427_) {
        return this.getStateForPlacement((BlockGetter)p_53427_.getLevel(), p_53427_.getClickedPos());
    }

    protected BlockState getStateForPlacement(BlockGetter p_53471_, BlockPos p_53472_) {
        BlockPos blockpos = p_53472_.below();
        BlockState blockstate = p_53471_.getBlockState(blockpos);
        if (!this.canCatchFire(p_53471_, p_53472_, Direction.UP) && !blockstate.isFaceSturdy(p_53471_, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.defaultBlockState();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(p_53471_, p_53472_.relative(direction), direction.getOpposite())));
            }
            return blockstate1;
        }
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState p_53454_, LevelReader p_53455_, BlockPos p_53456_) {
        BlockPos blockpos = p_53456_.below();
        return p_53455_.getBlockState(blockpos).isFaceSturdy((BlockGetter)p_53455_, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)p_53455_, p_53456_);
    }

    public void tick(BlockState p_221160_, ServerLevel p_221161_, BlockPos p_221162_, RandomSource p_221163_) {
        p_221161_.scheduleTick(p_221162_, (Block)this, GreenFireBlock.getFireTickDelay(p_221161_.random));
        if (p_221161_.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            if (!p_221160_.canSurvive((LevelReader)p_221161_, p_221162_)) {
                p_221161_.removeBlock(p_221162_, false);
            }
            BlockState blockstate = p_221161_.getBlockState(p_221162_.below());
            boolean flag = blockstate.isFireSource((LevelReader)p_221161_, p_221162_, Direction.UP);
            int i = (Integer)p_221160_.getValue((Property)AGE);
            if (!flag && p_221161_.isRaining() && this.isNearRain((Level)p_221161_, p_221162_) && p_221163_.nextFloat() < 0.2f + (float)i * 0.03f) {
                p_221161_.removeBlock(p_221162_, false);
            } else {
                boolean flag1;
                int j = Math.min(15, i + p_221163_.nextInt(3) / 2);
                if (i != j) {
                    p_221160_ = (BlockState)p_221160_.setValue((Property)AGE, (Comparable)Integer.valueOf(j));
                    p_221161_.setBlock(p_221162_, p_221160_, 4);
                }
                if (!flag) {
                    if (!this.isValidFireLocation((BlockGetter)p_221161_, p_221162_)) {
                        BlockPos blockpos = p_221162_.below();
                        if (!p_221161_.getBlockState(blockpos).isFaceSturdy((BlockGetter)p_221161_, blockpos, Direction.UP) || i > 3) {
                            p_221161_.removeBlock(p_221162_, false);
                        }
                        return;
                    }
                    if (i == 15 && p_221163_.nextInt(4) == 0 && !this.canCatchFire((BlockGetter)p_221161_, p_221162_.below(), Direction.UP)) {
                        p_221161_.removeBlock(p_221162_, false);
                        return;
                    }
                }
                int k = (flag1 = p_221161_.getBiome(p_221162_).is(BiomeTags.INCREASED_FIRE_BURNOUT)) ? -50 : 0;
                this.tryCatchFire((Level)p_221161_, p_221162_.east(), 300 + k, p_221163_, i, Direction.WEST);
                this.tryCatchFire((Level)p_221161_, p_221162_.west(), 300 + k, p_221163_, i, Direction.EAST);
                this.tryCatchFire((Level)p_221161_, p_221162_.below(), 250 + k, p_221163_, i, Direction.UP);
                this.tryCatchFire((Level)p_221161_, p_221162_.above(), 250 + k, p_221163_, i, Direction.DOWN);
                this.tryCatchFire((Level)p_221161_, p_221162_.north(), 300 + k, p_221163_, i, Direction.SOUTH);
                this.tryCatchFire((Level)p_221161_, p_221162_.south(), 300 + k, p_221163_, i, Direction.NORTH);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutableblockpos.setWithOffset((Vec3i)p_221162_, l, j1, i1);
                            int l1 = this.getIgniteOdds((LevelReader)p_221161_, (BlockPos)blockpos$mutableblockpos);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 40 + p_221161_.getDifficulty().getId() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || p_221163_.nextInt(k1) > i2 || p_221161_.isRaining() && this.isNearRain((Level)p_221161_, (BlockPos)blockpos$mutableblockpos)) continue;
                            int j2 = Math.min(15, i + p_221163_.nextInt(5) / 4);
                            p_221161_.setBlock((BlockPos)blockpos$mutableblockpos, this.getStateWithAge((LevelAccessor)p_221161_, (BlockPos)blockpos$mutableblockpos, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level p_53429_, BlockPos p_53430_) {
        return p_53429_.isRainingAt(p_53430_) || p_53429_.isRainingAt(p_53430_.west()) || p_53429_.isRainingAt(p_53430_.east()) || p_53429_.isRainingAt(p_53430_.north()) || p_53429_.isRainingAt(p_53430_.south());
    }

    @Deprecated
    public int getBurnOdds(BlockState p_221165_) {
        return p_221165_.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)p_221165_.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? 0 : this.burnOdds.getInt((Object)p_221165_.getBlock());
    }

    @Deprecated
    public int getIgniteOdds(BlockState p_221167_) {
        return p_221167_.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)p_221167_.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? 0 : this.igniteOdds.getInt((Object)p_221167_.getBlock());
    }

    private void tryCatchFire(Level p_53432_, BlockPos p_53433_, int p_53434_, RandomSource p_53435_, int p_53436_, Direction face) {
        int i = p_53432_.getBlockState(p_53433_).getFlammability((BlockGetter)p_53432_, p_53433_, face);
        if (p_53435_.nextInt(p_53434_) < i) {
            BlockState blockstate = p_53432_.getBlockState(p_53433_);
            if (p_53435_.nextInt(p_53434_ + 10) < 5 && !p_53432_.isRainingAt(p_53433_)) {
                int j = Math.min(p_53434_ + p_53435_.nextInt(5) / 4, 15);
                p_53432_.setBlock(p_53433_, this.getStateWithAge((LevelAccessor)p_53432_, p_53433_, j), 3);
            } else {
                p_53432_.removeBlock(p_53433_, false);
            }
            blockstate.onCaughtFire(p_53432_, p_53433_, face, null);
        }
    }

    private BlockState getStateWithAge(LevelAccessor p_53438_, BlockPos p_53439_, int p_53440_) {
        BlockState blockstate = GreenFireBlock.getState((BlockGetter)p_53438_, p_53439_);
        return blockstate.is((Block)TFMGColoredFires.GREEN_FIRE.get()) ? (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(p_53440_)) : blockstate;
    }

    private boolean isValidFireLocation(BlockGetter p_53486_, BlockPos p_53487_) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(p_53486_, p_53487_.relative(direction), direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    private int getIgniteOdds(LevelReader p_221157_, BlockPos p_221158_) {
        if (!p_221157_.isEmptyBlock(p_221158_)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = p_221157_.getBlockState(p_221158_.relative(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((BlockGetter)p_221157_, p_221158_.relative(direction), direction.getOpposite()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean canBurn(BlockState p_53489_) {
        return this.getIgniteOdds(p_53489_) > 0;
    }

    public void onPlace(BlockState p_53479_, Level p_53480_, BlockPos p_53481_, BlockState p_53482_, boolean p_53483_) {
        super.onPlace(p_53479_, p_53480_, p_53481_, p_53482_, p_53483_);
        p_53480_.scheduleTick(p_53481_, (Block)this, GreenFireBlock.getFireTickDelay(p_53480_.random));
    }

    private static int getFireTickDelay(RandomSource p_221149_) {
        return 30 + p_221149_.nextInt(10);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53465_) {
        p_53465_.add(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public static BlockState getState(BlockGetter p_49246_, BlockPos p_49247_) {
        return ((GreenFireBlock)((Object)TFMGColoredFires.GREEN_FIRE.get())).getStateForPlacement(p_49246_, p_49247_);
    }

    private void setFlammable(Block p_53445_, int p_53446_, int p_53447_) {
        if (p_53445_ == Blocks.AIR) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.igniteOdds.put((Object)p_53445_, p_53446_);
        this.burnOdds.put((Object)p_53445_, p_53447_);
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.getBlockState(pos).isFlammable(world, pos, face);
    }
}

