/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.fire_extinguisher;

import com.drmangotea.tfmg.base.spark.DryIceFlake;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FireExtinguisherItem
extends Item
implements CustomArmPoseItem {
    public static final int DRY_ICE_CAPACITY = 500;

    public FireExtinguisherItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int time) {
        int fillLevel = (Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0);
        if (fillLevel == 0) {
            return;
        }
        DryIceFlake flake = (DryIceFlake)TFMGEntityTypes.DRY_ICE_FLAKE.create(level);
        flake.setPos(entity.getX(), entity.getY() + (double)1.2f, entity.getZ());
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.1f, 0.04f);
        stack.set(TFMGDataComponents.AMOUNT, (Object)(fillLevel > 0 ? fillLevel - 1 : 0));
        flake.shoot(entity.getLookAngle().x, entity.getLookAngle().y, entity.getLookAngle().z, 0.5f, 10.0f);
        level.addFreshEntity((Entity)flake);
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        stack.set(TFMGDataComponents.AMOUNT, (Object)500);
    }

    public int getUseDuration(ItemStack stack) {
        return 696969;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFFFFFF;
    }

    public int getBarWidth(ItemStack stack) {
        float fillLevel = (float)((Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0)).intValue() / 500.0f;
        return Math.round(13.0f * fillLevel);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.NONE;
    }
}

