/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.smokestack;

import com.drmangotea.tfmg.content.machinery.misc.smokestack.SmokestackBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class SmokestackBlockEntity
extends SmartBlockEntity {
    int smokeTimer = 0;
    public FluidTank tankInventory = new SmartFluidTank(this, 8000, this::onFluidStackChanged){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().isSame((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource());
        }
    };
    protected IFluidHandler fluidCapability = this.tankInventory;

    public SmokestackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.SMOKESTACK.get(), (be, context) -> be.fluidCapability);
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        this.setChanged();
        this.sendData();
    }

    public static void makeParticles(Level level, BlockPos pos) {
        Random random = Create.RANDOM;
        int shouldSpawnSmoke = random.nextInt(7);
        if (shouldSpawnSmoke == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)((float)pos.getX() + random.nextFloat(1.0f)), (double)(pos.getY() + 1), (double)((float)pos.getZ() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
        }
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.smokeTimer > 0) {
            SmokestackBlockEntity.makeParticles(this.level, this.getBlockPos());
            --this.smokeTimer;
        }
        if (this.tankInventory.isEmpty()) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)SmokestackBlock.TOP)).booleanValue()) {
            this.tankInventory.drain(this.tankInventory.getSpace() < 1000 ? 50 : 10, IFluidHandler.FluidAction.EXECUTE);
            this.smokeTimer = 40;
        }
        if ((blockEntity = this.level.getBlockEntity(this.getBlockPos().above())) instanceof SmokestackBlockEntity) {
            SmokestackBlockEntity be = (SmokestackBlockEntity)blockEntity;
            int transferAmount = Math.min(this.tankInventory.getFluidAmount(), be.tankInventory.getCapacity() - be.tankInventory.getFluidAmount());
            this.tankInventory.drain(transferAmount, IFluidHandler.FluidAction.EXECUTE);
            be.tankInventory.fill(new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.get(), transferAmount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
        compound.putBoolean("Active", this.smokeTimer > 0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

