/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes;

import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGVatRecipeGen;
import com.drmangotea.tfmg.recipes.VatRecipeParams;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class VatMachineRecipe
extends ProcessingRecipe<RecipeInput, VatRecipeParams> {
    public List<String> machines;
    public List<String> allowedVatTypes;
    public int minSize;
    public int heatLevel = 0;

    public VatMachineRecipe(VatRecipeParams params) {
        super((IRecipeTypeInfo)TFMGRecipeTypes.VAT_MACHINE_RECIPE, (ProcessingRecipeParams)params);
        this.machines = params.machines;
        this.allowedVatTypes = params.allowedVatTypes;
        this.minSize = params.min_size;
        this.heatLevel = params.heat_level;
    }

    protected int getMaxInputCount() {
        return 4;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 4;
    }

    protected int getMaxFluidOutputCount() {
        return 4;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    public static class Serializer<R extends VatMachineRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<VatRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, VatRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, VatRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }

    public static class Builder<R extends VatMachineRecipe>
    extends ProcessingRecipeBuilder<VatRecipeParams, R, Builder<R>> {
        public Builder(Factory<R> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        protected VatRecipeParams createParams() {
            return new VatRecipeParams();
        }

        public Builder<R> self() {
            return this;
        }

        public Builder<R> values(TFMGVatRecipeGen.VatRecipeValues value) {
            ((VatRecipeParams)this.params).machines = value.machines;
            ((VatRecipeParams)this.params).allowedVatTypes = value.allowedVatTypes;
            ((VatRecipeParams)this.params).min_size = value.minSize;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Factory<R extends VatMachineRecipe>
    extends ProcessingRecipe.Factory<VatRecipeParams, R> {
        public R create(VatRecipeParams var1);
    }
}

