/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;

public class AttributeModifier {
    public static final AttributeModifier EMPTY = new AttributeModifier();
    @Nullable
    public String id;
    public String attribute = "";
    public float value = 0.0f;
    public AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_VALUE;

    public AttributeModifier() {
    }

    public AttributeModifier(ResourceLocation attribute, float value, AttributeModifier.Operation operation) {
        this(attribute.toString(), value, operation);
    }

    public AttributeModifier(String attribute, float value, AttributeModifier.Operation operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static AttributeModifier bonus(ResourceLocation attributeId, float value) {
        return new AttributeModifier(attributeId.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static AttributeModifier multiply(ResourceLocation attributeId, float value) {
        return new AttributeModifier(attributeId.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public static ArrayList<AttributeModifier> bonuses(List<ResourceLocation> attributeIds, float value) {
        ArrayList<AttributeModifier> spellAttributes = new ArrayList<AttributeModifier>();
        for (ResourceLocation attributeId : attributeIds) {
            spellAttributes.add(new AttributeModifier(attributeId.toString(), value, AttributeModifier.Operation.ADD_VALUE));
        }
        return spellAttributes;
    }
}

