/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SimpleSoundGenerator
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SimpleSoundGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateSounds(Builder var1);

    private static LinkedHashMap<String, Sound> createFileContent(String namespace, List<String> sounds) {
        LinkedHashMap<String, Sound> map = new LinkedHashMap<String, Sound>();
        for (String sound : sounds) {
            map.put(sound, new Sound(List.of(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)sound).toString())));
        }
        return map;
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        Builder builder = new Builder();
        this.generateSounds(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            LinkedHashMap<String, Sound> content = SimpleSoundGenerator.createFileContent(entry.namespace(), entry.sounds);
            JsonElement json = gson.toJsonTree(content);
            Path path = this.getFilePath(entry.namespace());
            writes.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Simple Sound Entry Generator";
    }

    private Path getFilePath(String namespace) {
        return this.dataOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "").json(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"sounds"));
    }

    private record Sound(List<String> sounds) {
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();
    }

    public record Entry(String namespace, List<String> sounds) {
    }
}

