/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.set;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.tags.SpellEngineItemTags;
import org.jetbrains.annotations.Nullable;

public class EquipmentSet {
    public static String translationKey(Holder<Definition> entry) {
        return EquipmentSet.translationKey(((ResourceKey)entry.unwrapKey().get()).location());
    }

    public static String translationKey(ResourceLocation id) {
        return "equipment_set." + id.getNamespace() + "." + id.getPath();
    }

    public static List<Result> collectFrom(List<SourcedItemStack> stacks, Level world) {
        Object items;
        LinkedHashMap<ResourceLocation, LinkedHashMap> sets = new LinkedHashMap<ResourceLocation, LinkedHashMap>();
        for (SourcedItemStack sourcedStack : stacks) {
            ItemStack stack = sourcedStack.itemstack();
            ResourceLocation component = (ResourceLocation)stack.get(SpellDataComponents.EQUIPMENT_SET);
            if (component == null) continue;
            ResourceLocation id = component;
            Holder.Reference itemEntry = stack.getItem().builtInRegistryHolder();
            if (sourcedStack.sourceName.contains("hand") && !stack.is(SpellEngineItemTags.HANDHELD)) continue;
            items = sets.computeIfAbsent(id, k -> new LinkedHashMap());
            ((LinkedHashMap)sets.get(id)).put(itemEntry.key(), stack);
        }
        Registry registry = world.registryAccess().registryOrThrow(EquipmentSetRegistry.KEY);
        ArrayList<Result> results = new ArrayList<Result>();
        for (Map.Entry entry : sets.entrySet()) {
            ResourceLocation setId = (ResourceLocation)entry.getKey();
            Optional set = registry.getHolder(setId);
            if (!set.isPresent()) continue;
            items = ((LinkedHashMap)entry.getValue()).values().stream().toList();
            results.add(new Result((Holder<Definition>)((Holder)set.get()), (List<ItemStack>)items));
        }
        return results;
    }

    public static List<ItemAttributeModifiers> attributesFrom(List<Result> results) {
        ArrayList<ItemAttributeModifiers> attributeModifiers = new ArrayList<ItemAttributeModifiers>();
        for (Result result : results) {
            Definition set = (Definition)result.set.value();
            for (Bonus bonus : set.bonuses) {
                if (result.items().size() < bonus.requiredPieceCount || bonus.attributes == null) continue;
                attributeModifiers.add(bonus.attributes);
            }
        }
        return attributeModifiers;
    }

    public record SourcedItemStack(ItemStack itemstack, String sourceName) {
    }

    public record Result(Holder<Definition> set, List<ItemStack> items) {
    }

    public record Definition(String name, HolderSet<Item> items, List<Bonus> bonuses) {
        public static final Codec<Definition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Definition::name), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("items").forGetter(Definition::items), (App)Bonus.CODEC.listOf().fieldOf("bonuses").forGetter(Definition::bonuses)).apply((Applicative)instance, Definition::new));
    }

    public record Bonus(int requiredPieceCount, @Nullable ItemAttributeModifiers attributes, @Nullable SpellContainer spells) {
        public static final Codec<Bonus> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("required_piece_count").forGetter(Bonus::requiredPieceCount), (App)ItemAttributeModifiers.CODEC.optionalFieldOf("attributes").forGetter(Bonus::getAttributes), (App)SpellContainer.CODEC.optionalFieldOf("spells").forGetter(Bonus::getSpells)).apply((Applicative)instance, Bonus::create));

        public Optional<ItemAttributeModifiers> getAttributes() {
            return Optional.ofNullable(this.attributes);
        }

        public Optional<SpellContainer> getSpells() {
            return Optional.ofNullable(this.spells);
        }

        public static Bonus create(int requiredPieceCount, Optional<ItemAttributeModifiers> attributes, Optional<SpellContainer> spells) {
            return new Bonus(requiredPieceCount, attributes.orElse(null), spells.orElse(null));
        }

        public static Bonus withSpells(int requiredPieceCount, SpellContainer spells) {
            return new Bonus(requiredPieceCount, null, spells);
        }

        public static Bonus withAttributes(int requiredPieceCount, ItemAttributeModifiers attributes) {
            return new Bonus(requiredPieceCount, attributes, null);
        }
    }

    public static interface Owner {
        public List<Result> getActiveEquipmentSets();

        public void setActiveEquipmentSets(List<Result> var1);
    }
}

