/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.set;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.mixin.client.ItemStackTooltipAccessor;
import org.jetbrains.annotations.Nullable;

public class EquipmentSetTooltip {
    public static void appendLines(ItemStack stack, List<Component> tooltip) {
        List<Component> text;
        if (stack.get(SpellDataComponents.EQUIPMENT_SET) != null && !(text = EquipmentSetTooltip.textFor(stack, (Player)Minecraft.getInstance().player)).isEmpty()) {
            tooltip.addAll(text);
        }
    }

    public static List<Component> textFor(ItemStack stack, @Nullable Player player) {
        ArrayList<Component> text = new ArrayList<Component>();
        ResourceLocation component = (ResourceLocation)stack.get(SpellDataComponents.EQUIPMENT_SET);
        if (component == null) {
            return text;
        }
        Optional optionalEntry = EquipmentSetRegistry.from(player.level()).getHolder(component);
        if (optionalEntry.isPresent() && player != null && player.level() != null) {
            Holder.Reference equipmentSetEntry = (Holder.Reference)optionalEntry.get();
            EquipmentSet.Definition equipmentSet = (EquipmentSet.Definition)equipmentSetEntry.value();
            int setSize = equipmentSet.items().size();
            List<EquipmentSet.Result> activeSets = ((EquipmentSet.Owner)player).getActiveEquipmentSets();
            List<Object> wornItems = List.of();
            for (EquipmentSet.Result entry : activeSets) {
                if (!((ResourceKey)entry.set().unwrapKey().get()).equals(equipmentSetEntry.unwrapKey().get())) continue;
                wornItems = entry.items();
            }
            text.add((Component)Component.literal((String)" "));
            text.add((Component)Component.translatable((String)EquipmentSet.translationKey((Holder<EquipmentSet.Definition>)equipmentSetEntry)).append((Component)Component.literal((String)(" (" + wornItems.size() + "/" + setSize + ")"))).withStyle(ChatFormatting.GOLD));
            for (Holder item : equipmentSet.items()) {
                boolean isWorn = wornItems.stream().anyMatch(wornItem -> wornItem.is((Item)item.value()));
                text.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)((Item)item.value()).getDescriptionId()).withStyle(isWorn ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY)));
            }
            for (EquipmentSet.Bonus bonus : equipmentSet.bonuses()) {
                boolean isActive = wornItems.size() >= bonus.requiredPieceCount();
                text.addAll(EquipmentSetTooltip.bonusText(player, stack, bonus, isActive));
            }
        }
        return text;
    }

    public static List<Component> bonusText(Player player, ItemStack itemStack, EquipmentSet.Bonus bonus, boolean isActive) {
        ChatFormatting formatting;
        SpellTooltip.SpellInfo spellText;
        MutableComponent bonusTitle = Component.translatable((String)"equipment_set.logic.bonus.count", (Object[])new Object[]{bonus.requiredPieceCount()});
        ArrayList<Component> bonusLines = new ArrayList<Component>();
        if (bonus.attributes() != null) {
            ItemStackTooltipAccessor tooltipUtil = (ItemStackTooltipAccessor)ItemStack.EMPTY;
            for (ItemAttributeModifiers.Entry modifier : bonus.attributes().modifiers()) {
                tooltipUtil.spellEngine_appendAttributeModifierTooltip(bonusLines::add, player, (Holder<Attribute>)modifier.attribute(), modifier.modifier());
            }
        }
        if (bonus.spells() != null && (spellText = SpellTooltip.getSpellInfo(itemStack, bonus.spells(), player, true, false)) != null) {
            bonusLines.addAll(spellText.content());
        }
        ArrayList<Component> finalLines = new ArrayList<Component>();
        ChatFormatting chatFormatting = formatting = isActive ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY;
        if (bonusLines.size() == 1) {
            Component line = (Component)bonusLines.get(0);
            finalLines.add((Component)bonusTitle.append((Component)(isActive ? line : Component.literal((String)line.getString()))).withStyle(formatting));
        } else {
            finalLines.add((Component)bonusTitle.withStyle(formatting));
            for (Component line : bonusLines) {
                finalLines.add((Component)Component.literal((String)" ").append((Component)(isActive ? line : Component.literal((String)line.getString()))).withStyle(formatting));
            }
        }
        return finalLines;
    }
}

