/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.spell_engine.PlatformClient;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.compat.SlotModCompat;
import net.spell_engine.utils.AttributeModifierUtil;
import org.jetbrains.annotations.Nullable;

public class AutoSwapHelper {
    public static boolean autoSwapForAttack() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = (ItemStack)player.getInventory().offhand.get(0);
        if (mainHand.isEmpty() || offHand.isEmpty() || AutoSwapHelper.isPlaceable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.hasSpells(mainHand) && !AutoSwapHelper.isUsable(mainHand)) {
            return false;
        }
        if (!AutoSwapHelper.isMeleeWeapon(mainHand) && AutoSwapHelper.isMeleeWeapon(offHand)) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static boolean autoSwapForSpells() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = (ItemStack)player.getInventory().offhand.get(0);
        if (mainHand.isEmpty() || offHand.isEmpty() || AutoSwapHelper.isUsable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.isAnyWeapon(offHand)) {
            return false;
        }
        SpellContainer.ContentType mainHandType = AutoSwapHelper.spellContentType(mainHand);
        SpellContainer.ContentType offHandType = AutoSwapHelper.spellContentType(offHand);
        SpellContainer.ContentType spellbookType = AutoSwapHelper.spellContentType(SlotModCompat.getEquippedSpellBook((Player)player));
        if (spellbookType != null && !AutoSwapHelper.hasSpells(mainHand) && mainHandType != spellbookType && offHandType == spellbookType) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static void swapHeldItems() {
        LocalPlayer player = Minecraft.getInstance().player;
        PlatformClient.util().sendVanillaPacket_C2S(player, (Packet<?>)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
    }

    public static boolean isPlaceable(ItemStack itemStack) {
        return itemStack.getItem() instanceof BlockItem;
    }

    public static boolean isUsable(ItemStack itemStack) {
        return itemStack.getUseAnimation() != UseAnim.NONE || itemStack.getItem() instanceof DiggerItem;
    }

    public static boolean isMeleeWeapon(ItemStack itemStack) {
        return AttributeModifierUtil.hasModifier(itemStack, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) && AttributeModifierUtil.hasModifier(itemStack, (Holder<Attribute>)Attributes.ATTACK_SPEED);
    }

    public static boolean isAnyWeapon(ItemStack itemStack) {
        if (AutoSwapHelper.isMeleeWeapon(itemStack)) {
            return true;
        }
        return FabricLoader.getInstance().isModLoaded("ranged_weapon_api") && AttributeModifierUtil.hasModifier(itemStack, (Holder<Attribute>)EntityAttributes_RangedWeapon.DAMAGE.entry);
    }

    @Nullable
    private static SpellContainer.ContentType spellContentType(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return container.content();
        }
        return null;
    }

    private static boolean hasSpells(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return !container.spell_ids().isEmpty();
        }
        return false;
    }
}

