/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.WrappedKeybinding;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellHotbar {
    public static SpellHotbar INSTANCE = new SpellHotbar();
    public List<Slot> slots = List.of();
    public StructuredSlots structuredSlots = new StructuredSlots(null, List.of());
    @Nullable
    private Handle handledThisTick = null;
    @Nullable
    private Handle lastPressed = null;
    private int itemUseCooldown = 0;
    private Holder<Spell> attemptedSpell = null;
    private ResourceLocation lastSyncedSpellId = null;
    private final HashMap<KeyMapping, UseCase> debounced = new HashMap();

    public boolean update(LocalPlayer player, Options options) {
        boolean changed = false;
        int initialSlotCount = this.slots.size();
        SpellContainer mergedContainer = SpellContainerSource.activeContainerOf((Player)player);
        ArrayList<Slot> slots = new ArrayList<Slot>();
        ArrayList<Slot> otherSlots = new ArrayList<Slot>();
        Slot onUseKey = null;
        List<WrappedKeybinding> allBindings = Keybindings.Wrapped.all();
        InputConstants.Key useKey = ((KeybindingAccessor)options.keyUse).spellEngine_getBoundKey();
        WrappedKeybinding useKeyBinding = new WrappedKeybinding(options.keyUse, WrappedKeybinding.VanillaAlternative.USE_KEY);
        if (mergedContainer != null && !mergedContainer.spell_ids().isEmpty()) {
            ItemUseExpectation itemUseExpectation = SpellHotbar.expectedUseStack((Player)player);
            if (itemUseExpectation != null) {
                onUseKey = new Slot(null, SpellCast.Mode.ITEM_USE, itemUseExpectation.itemStack, useKeyBinding, null);
            }
            List<String> spellIds = mergedContainer.spell_ids();
            List<Holder.Reference> spellEntryList = spellIds.stream().map(idString -> {
                ResourceLocation id = ResourceLocation.parse((String)idString);
                return SpellRegistry.from(player.level()).getHolder(id).orElse(null);
            }).filter(Objects::nonNull).toList();
            int keyBindingIndex = 0;
            for (Holder holder : spellEntryList) {
                WrappedKeybinding.Unwrapped unwrapped;
                Spell spell = (Spell)holder.value();
                if (spell == null) continue;
                WrappedKeybinding keyBinding = null;
                if (keyBindingIndex >= allBindings.size()) continue;
                keyBinding = allBindings.get(keyBindingIndex);
                ++keyBindingIndex;
                if (SpellEngineClient.config.spellHotbarUseKey && onUseKey == null) {
                    keyBinding = useKeyBinding;
                }
                Slot slot = new Slot((Holder<Spell>)holder, SpellCast.Mode.from(spell), null, keyBinding, null);
                if (keyBinding != null && (unwrapped = keyBinding.get(options)) != null) {
                    InputConstants.Key hotbarKey = ((KeybindingAccessor)unwrapped.keyBinding()).spellEngine_getBoundKey();
                    if (hotbarKey.equals((Object)useKey)) {
                        onUseKey = slot;
                    } else {
                        otherSlots.add(slot);
                    }
                }
                slots.add(slot);
            }
            if (itemUseExpectation != null) {
                if (itemUseExpectation.isMainHand()) {
                    slots.addFirst(onUseKey);
                } else {
                    slots.addLast(onUseKey);
                }
            }
        }
        changed = initialSlotCount != slots.size();
        this.structuredSlots = new StructuredSlots(onUseKey, otherSlots);
        this.slots = slots;
        return changed;
    }

    public void prepare(int itemUseCooldown) {
        this.itemUseCooldown = itemUseCooldown;
        this.handledThisTick = null;
        if (this.lastPressed == null) {
            this.attemptedSpell = null;
        }
        this.updateDebounced();
    }

    @Nullable
    public Handle handleAll(LocalPlayer player, Options options) {
        return this.handleSlotsInternal(player, this.slots, options);
    }

    @Nullable
    public Handle handleUseKey(LocalPlayer player, Options options) {
        return this.handleSlotsInternal(player, this.structuredSlots.onUseKey != null ? List.of(this.structuredSlots.onUseKey) : List.of(), options);
    }

    @Nullable
    public Handle handleOther(LocalPlayer player, Options options) {
        return this.handleSlotsInternal(player, this.structuredSlots.other(), options);
    }

    @Nullable
    public Handle handleSome(LocalPlayer player, @Nullable Slot slot, Options options) {
        if (slot == null) {
            return null;
        }
        return this.handleSlotsInternal(player, List.of(slot), options);
    }

    @Nullable
    public Handle lastHandled() {
        return this.handledThisTick;
    }

    @Nullable
    private Handle handleSlotsInternal(LocalPlayer player, List<Slot> slots, Options options) {
        if (this.handledThisTick != null || player.isSpectator()) {
            return null;
        }
        if (Keybindings.bypass_spell_hotbar.isDown() || SpellEngineClient.config.sneakingByPassSpellHotbar && options.keyShift.isDown()) {
            return null;
        }
        SpellCasterClient caster = (SpellCasterClient)player;
        SpellCast.Progress casted = caster.getSpellCastProgress();
        ItemStack casterStack = player.getMainHandItem();
        for (Slot slot : slots) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (slot.keybinding == null || (unwrapped = slot.keybinding.get(options)) == null) continue;
            KeyMapping keyBinding = unwrapped.keyBinding();
            boolean pressed = keyBinding.isDown();
            Handle handle = Handle.from(slot, keyBinding, unwrapped.vanillaHandle());
            if (pressed) {
                this.lastPressed = handle;
            }
            switch (slot.castMode()) {
                case ITEM_USE: {
                    if (!options.keyUse.isDown()) break;
                    return null;
                }
                case INSTANT: {
                    Handle handledWithAttempt;
                    if (!pressed) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell);
                    this.handledThisTick = handledWithAttempt = handle.withAttempt(attempt);
                    this.displayAttempt(attempt, slot.spell);
                    return handledWithAttempt;
                }
                case CHARGE: 
                case CHANNEL: {
                    Handle handledWithAttempt;
                    if (casted != null && casted.process().id().equals((Object)((ResourceKey)slot.spell.unwrapKey().get()).location())) {
                        boolean needsToBeHeld;
                        boolean bl = needsToBeHeld = SpellHelper.isChanneled((Spell)casted.process().spell().value()) ? SpellEngineClient.config.holdToCastChannelled : SpellEngineClient.config.holdToCastCharged;
                        if (needsToBeHeld) {
                            if (pressed) break;
                            caster.cancelSpellCast();
                            this.handledThisTick = handle;
                            return handle;
                        }
                        if (!pressed || !this.isReleased(keyBinding, UseCase.START)) break;
                        caster.cancelSpellCast();
                        this.debounce(keyBinding, UseCase.STOP);
                        this.handledThisTick = handle;
                        return handle;
                    }
                    if (!pressed || !this.isReleased(keyBinding, UseCase.STOP)) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell);
                    this.debounce(keyBinding, UseCase.START);
                    this.handledThisTick = handledWithAttempt = handle.withAttempt(attempt);
                    this.displayAttempt(attempt, slot.spell);
                    return handledWithAttempt;
                }
            }
            if (!pressed) continue;
            this.handledThisTick = handle;
            return handle;
        }
        this.lastPressed = null;
        return null;
    }

    private void displayAttempt(SpellCast.Attempt attempt, Holder<Spell> spell) {
        if (Objects.equals(spell, this.attemptedSpell)) {
            return;
        }
        if (attempt.isFail()) {
            HudMessages.INSTANCE.castAttemptError(attempt);
        }
        this.attemptedSpell = spell;
    }

    public void syncItemUseSkill(LocalPlayer player) {
        ResourceLocation idToSync = null;
        if (!Objects.equals(idToSync, this.lastSyncedSpellId)) {
            ClientPlayNetworking.send((CustomPacketPayload)new Packets.SpellCastSync(idToSync, 1.0f, 1000));
            this.lastSyncedSpellId = idToSync;
        }
    }

    private boolean isReleased(KeyMapping keybinding, UseCase use) {
        return this.debounced.get(keybinding) != use;
    }

    private void debounce(KeyMapping keybinding, UseCase use) {
        this.debounced.put(keybinding, use);
    }

    private void updateDebounced() {
        this.debounced.entrySet().removeIf(entry -> !((KeyMapping)entry.getKey()).isDown());
    }

    public static ItemUseExpectation expectedUseStack(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (itemStack.getUseAnimation() == UseAnim.NONE) continue;
            return new ItemUseExpectation(hand, itemStack);
        }
        return null;
    }

    public boolean isShowingItemUse() {
        return this.structuredSlots.onUseKey != null && this.structuredSlots.onUseKey.itemStack != null;
    }

    public record StructuredSlots(@Nullable Slot onUseKey, List<Slot> other) {
    }

    public record Slot(Holder<Spell> spell, SpellCast.Mode castMode, @Nullable ItemStack itemStack, @Nullable WrappedKeybinding keybinding, @Nullable KeyMapping modifier) {
        @Nullable
        public KeyMapping getKeyBinding(Options options) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (this.keybinding != null && (unwrapped = this.keybinding.get(options)) != null) {
                return unwrapped.keyBinding();
            }
            return null;
        }
    }

    public record Handle(Holder<Spell> spell, KeyMapping keyBinding, @Nullable WrappedKeybinding.Category category, SpellCast.Attempt attempt) {
        public static Handle from(Slot slot, KeyMapping keyBinding, @Nullable WrappedKeybinding.Category category) {
            return new Handle(slot.spell, keyBinding, category, null);
        }

        public Handle withAttempt(SpellCast.Attempt attempt) {
            return new Handle(this.spell, this.keyBinding, this.category, attempt);
        }

        public boolean isSuccessfulAttempt() {
            return this.attempt != null && this.attempt.isSuccess();
        }

        public boolean isUseKey(Options options) {
            return this.keyBinding == null ? false : this.keyBinding.same(options.keyUse);
        }
    }

    public record ItemUseExpectation(InteractionHand hand, ItemStack itemStack) {
        public boolean isMainHand() {
            return this.hand == InteractionHand.MAIN_HAND;
        }
    }

    private static enum UseCase {
        START,
        STOP;

    }
}

