/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.casting;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellHelper;
import org.jetbrains.annotations.Nullable;

public class SpellCast {

    public static enum Animation {
        CASTING,
        RELEASE,
        MISC;

    }

    public static enum Action {
        CHANNEL,
        RELEASE,
        TRIGGER;

    }

    public static enum Mode {
        INSTANT,
        CHARGE,
        CHANNEL,
        PASSIVE,
        ITEM_USE;


        public static Mode from(Spell spell) {
            if (spell.active != null) {
                if (spell.active.cast.duration <= 0.0f) {
                    return INSTANT;
                }
                return SpellHelper.isChanneled(spell) ? CHANNEL : CHARGE;
            }
            return PASSIVE;
        }
    }

    public record Progress(float ratio, Process process) {
    }

    public record Process(Holder<Spell> spell, Item item, float speed, int length, long startedAt) {
        public int spellCastTicksSoFar(long worldTime) {
            return (int)Math.max(worldTime - this.startedAt, 0L);
        }

        public Progress progress(int castTicks) {
            if (this.length <= 0) {
                return new Progress(1.0f, this);
            }
            float ratio = Math.min((float)castTicks / (float)this.length(), 1.0f);
            return new Progress(ratio, this);
        }

        public Progress progress(long worldTime) {
            int castTicks = this.spellCastTicksSoFar(worldTime);
            return this.progress(castTicks);
        }

        public ResourceLocation id() {
            return ((ResourceKey)this.spell.unwrapKey().get()).location();
        }

        public SyncFormat sync() {
            return new SyncFormat(this.id().toString(), this.speed, this.length);
        }

        public String fastSyncJSON() {
            return "{\"i\":\"" + this.id().toString() + "\",\"s\":" + this.speed + ",\"l\":" + this.length + "}";
        }

        @Nullable
        public static Process fromSync(Level world, SyncFormat sync, Item item, long startedAt) {
            String spellId = sync.i();
            if (spellId.isEmpty()) {
                return null;
            }
            ResourceLocation id = ResourceLocation.parse((String)spellId);
            Holder.Reference spellEntry = SpellRegistry.from(world).getHolder(id).orElse(null);
            return new Process((Holder<Spell>)spellEntry, item, sync.s(), sync.l(), startedAt);
        }

        public record SyncFormat(String i, float s, int l) {
        }
    }

    public record Duration(float speed, int length) {
        public static final Duration EMPTY = new Duration(0.0f, 0);
    }

    public record Attempt(Result result, @Nullable MissingItemInfo missingItem, @Nullable OnCooldownInfo onCooldown) {
        public static Attempt none() {
            return new Attempt(Result.NONE, null, null);
        }

        public static Attempt success() {
            return new Attempt(Result.SUCCESS, null, null);
        }

        public static Attempt failMissingItem(MissingItemInfo missingItem) {
            return new Attempt(Result.MISSING_ITEM, missingItem, null);
        }

        public static Attempt failOnCooldown(OnCooldownInfo onCooldown) {
            return new Attempt(Result.ON_COOLDOWN, null, onCooldown);
        }

        public boolean isSuccess() {
            return this.result == Result.SUCCESS;
        }

        public boolean isFail() {
            return this.result != Result.SUCCESS && this.result != Result.NONE;
        }

        public static enum Result {
            SUCCESS,
            MISSING_ITEM,
            ON_COOLDOWN,
            NONE;

        }

        public record MissingItemInfo(Ammo.Searched item) {
        }

        public record OnCooldownInfo() {
        }
    }
}

