/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.target;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.compat.MultipartEntityCompat;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.SpellTarget;
import org.jetbrains.annotations.Nullable;

public class EntityRelations {
    private static Map<TagKey<EntityType<?>>, EntityRelation> RELATION_TAG_CACHE = null;
    private static final Map<String, TeamMatcher> TEAM_MATCHERS = new LinkedHashMap<String, TeamMatcher>();
    private static final boolean[][] TABLE_OF_ULTIMATE_JUSTICE;

    public static EntityRelation getRelation(LivingEntity attacker, Entity target) {
        Object tameable;
        LivingEntity owner;
        ServerConfig config = SpellEngineMod.config;
        if (attacker == target) {
            return EntityRelation.ALLY;
        }
        if ((target = MultipartEntityCompat.coalesce(target)) instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)target).getOwner()) != null) {
            return attacker == owner ? config.player_relation_to_owned_pets : EntityRelations.getRelation(attacker, (Entity)owner);
        }
        if (target instanceof HangingEntity) {
            return EntityRelation.NEUTRAL;
        }
        for (TeamMatcher matcher : TEAM_MATCHERS.values()) {
            TeamRelation relation = matcher.getRelation((Entity)attacker, target);
            if (relation == null) continue;
            return relation.areTeammates() ? (relation.friendlyFireAllowed() ? config.player_relation_to_teammates : EntityRelation.ALLY) : EntityRelation.HOSTILE;
        }
        Holder targetTypeEntry = BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)target.getType());
        ResourceLocation id = ((ResourceKey)targetTypeEntry.unwrapKey().get()).location();
        EntityRelation mappedRelation = config.player_relations.get(id.toString());
        if (mappedRelation != null) {
            return mappedRelation;
        }
        for (Map.Entry<TagKey<EntityType<?>>, EntityRelation> entry : EntityRelations.getRelationTagsCache().entrySet()) {
            if (!targetTypeEntry.is(entry.getKey())) continue;
            return entry.getValue();
        }
        if (target instanceof AgeableMob) {
            return EntityRelation.coalesce(config.player_relation_to_passives, EntityRelation.HOSTILE);
        }
        if (target instanceof Monster) {
            return EntityRelation.coalesce(config.player_relation_to_hostiles, EntityRelation.HOSTILE);
        }
        return EntityRelation.coalesce(config.player_relation_to_other, EntityRelation.HOSTILE);
    }

    private static Map<TagKey<EntityType<?>>, EntityRelation> getRelationTagsCache() {
        if (RELATION_TAG_CACHE == null) {
            RELATION_TAG_CACHE = new HashMap();
            for (Map.Entry<String, EntityRelation> entrySet : SpellEngineMod.config.player_relation_tags.entrySet()) {
                String tagString = entrySet.getKey();
                EntityRelation relation = entrySet.getValue();
                TagKey tag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tagString));
                RELATION_TAG_CACHE.put(tag, relation);
            }
        }
        return RELATION_TAG_CACHE;
    }

    public static void registerTeamMatcher(String name, TeamMatcher matcher) {
        TEAM_MATCHERS.put(name, matcher);
    }

    public static boolean actionAllowed(SpellTarget.FocusMode focusMode, SpellTarget.Intent intent, LivingEntity attacker, Entity target) {
        EntityRelation relation = EntityRelations.getRelation(attacker, target);
        int row = 0;
        if (intent == SpellTarget.Intent.HELPFUL) {
            row += 2;
        }
        if (focusMode == SpellTarget.FocusMode.AREA) {
            ++row;
        }
        int column = 0;
        switch (relation) {
            case ALLY: {
                column = 0;
                break;
            }
            case FRIENDLY: {
                column = 1;
                break;
            }
            case NEUTRAL: {
                column = 2;
                break;
            }
            case HOSTILE: {
                column = 3;
                break;
            }
            case MIXED: {
                column = 4;
            }
        }
        return TABLE_OF_ULTIMATE_JUSTICE[row][column];
    }

    public static boolean allowedToHurt(Entity e1, Entity e2) {
        PlayerTeam abstractTeam = e1.getTeam();
        PlayerTeam abstractTeam2 = e2.getTeam();
        if (abstractTeam == null) {
            return true;
        }
        return !abstractTeam.isAlliedTo((Team)abstractTeam2) || abstractTeam.isAllowFriendlyFire();
    }

    static {
        EntityRelations.registerTeamMatcher("vanilla", (entity1, entity2) -> {
            PlayerTeam team1 = entity1.getTeam();
            PlayerTeam team2 = entity2.getTeam();
            if (team1 == null || team2 == null) {
                return null;
            }
            boolean friendlyFire = team1.isAllowFriendlyFire();
            return new TeamRelation(entity1.isAlliedTo(entity2), friendlyFire);
        });
        TABLE_OF_ULTIMATE_JUSTICE = new boolean[][]{{false, true, true, true, true}, {false, false, false, true, true}, {true, true, true, false, true}, {true, true, false, false, true}};
    }

    public static interface TeamMatcher {
        @Nullable
        public TeamRelation getRelation(Entity var1, Entity var2);
    }

    public record TeamRelation(boolean areTeammates, boolean friendlyFireAllowed) {
    }
}

