/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.network.Packets;

public class AnimationHelper {
    public static void sendAnimation(Player animatedPlayer, Collection<ServerPlayer> trackingPlayers, SpellCast.Animation type, String name, float speed) {
        if (name == null || name.isEmpty()) {
            return;
        }
        Packets.SpellAnimation packet = new Packets.SpellAnimation(animatedPlayer.getId(), type, name, speed);
        if (animatedPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)animatedPlayer;
            AnimationHelper.sendPacketToPlayer(serverPlayer2, packet);
        }
        trackingPlayers.forEach(serverPlayer -> AnimationHelper.sendPacketToPlayer(serverPlayer, packet));
    }

    private static void sendPacketToPlayer(ServerPlayer serverPlayer, Packets.SpellAnimation packet) {
        try {
            if (ServerPlayNetworking.canSend((ServerPlayer)serverPlayer, (ResourceLocation)Packets.SpellAnimation.ID)) {
                ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

