/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;

public class AttributeModifierUtil {
    @NotNull
    public static Multimap<Holder<Attribute>, AttributeModifier> modifierMultimap(ItemStack itemStack) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        HashMultimap modifiersMap = HashMultimap.create();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            modifiersMap.put((Object)entry.attribute(), (Object)entry.modifier());
        }
        return modifiersMap;
    }

    public static boolean hasModifier(ItemStack itemStack, Holder<Attribute> attribute) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!entry.attribute().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public static double flatBonusFrom(ItemStack itemStack, Holder<Attribute> attribute) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!entry.attribute().equals(attribute) || entry.modifier().operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            return entry.modifier().amount();
        }
        return 0.0;
    }

    public static boolean isItemStackEquipped(ItemStack itemStack, Player player) {
        if (player.getMainHandItem().equals(itemStack)) {
            return true;
        }
        for (ItemStack armorSlot : player.getInventory().armor) {
            if (!armorSlot.equals(itemStack)) continue;
            return true;
        }
        for (ItemStack offhandSlot : player.getInventory().offhand) {
            if (!offhandSlot.equals(itemStack)) continue;
            return true;
        }
        return false;
    }
}

