/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.internals.delivery.Beam;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    public static Vec3 locationFromRayCast(Entity caster, float range) {
        Vec3 look;
        Vec3 end;
        Vec3 start = caster.getEyePosition();
        BlockHitResult hit = TargetHelper.raycastObstacle(caster, start, end = start.add(look = caster.getViewVector(1.0f).normalize().scale((double)range)));
        if (hit.getType() == HitResult.Type.BLOCK) {
            return hit.getLocation();
        }
        return end;
    }

    public static Entity targetFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        AABB searchAABB;
        Vec3 look;
        Vec3 end;
        Vec3 start = caster.getEyePosition();
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)caster, (Vec3)start, (Vec3)(end = start.add(look = caster.getViewVector(1.0f).normalize().scale((double)range))), (AABB)(searchAABB = caster.getBoundingBox().inflate((double)range, (double)range, (double)range)), target -> !target.isSpectator() && target.isPickable() && predicate.test((Entity)target), (double)(range * range));
        if (hitResult != null && (hitResult.getLocation() == null || TargetHelper.raycastObstacleFree(caster, start, hitResult.getLocation()))) {
            return hitResult.getEntity();
        }
        return null;
    }

    public static List<Entity> targetsFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        Vec3 start = caster.getEyePosition();
        Vec3 look = caster.getViewVector(1.0f).normalize().scale((double)range);
        Vec3 end = start.add(look);
        AABB searchAABB = caster.getBoundingBox().inflate((double)range, (double)range, (double)range);
        List<EntityHit> entitiesHit = TargetHelper.raycastMultiple(caster, start, end, searchAABB, target -> !target.isSpectator() && target.isPickable() && predicate.test((Entity)target), range * range);
        return entitiesHit.stream().filter(hit -> hit.position() == null || TargetHelper.raycastObstacleFree(caster, start, hit.position())).sorted(new Comparator<EntityHit>(){

            @Override
            public int compare(EntityHit hit1, EntityHit hit2) {
                if (hit1.squaredDistanceToSource == hit2.squaredDistanceToSource) {
                    return 0;
                }
                return hit1.squaredDistanceToSource < hit2.squaredDistanceToSource ? -1 : 1;
            }
        }).map(hit -> hit.entity).toList();
    }

    @Nullable
    private static List<EntityHit> raycastMultiple(Entity sourceEntity, Vec3 min, Vec3 max, AABB searchBox, Predicate<Entity> predicate, double squaredDistance) {
        Level world = sourceEntity.level();
        double e = squaredDistance;
        ArrayList<EntityHit> entities = new ArrayList<EntityHit>();
        Vec3 vec3d = null;
        for (Entity entity : world.getEntities(sourceEntity, searchBox, predicate)) {
            Vec3 hitPosition;
            double f;
            AABB box2 = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            Optional raycastResult = box2.clip(min, max);
            if (box2.contains(min)) {
                if (!(e >= 0.0)) continue;
                vec3d = raycastResult.orElse(min);
                entities.add(new EntityHit(entity, vec3d, 0.0));
                e = 0.0;
                continue;
            }
            if (!raycastResult.isPresent() || !((f = min.distanceToSqr(hitPosition = (Vec3)raycastResult.get())) < e) && e != 0.0) continue;
            if (entity.getRootVehicle() == sourceEntity.getRootVehicle()) {
                if (e != 0.0) continue;
                vec3d = hitPosition;
                entities.add(new EntityHit(entity, vec3d, entity.distanceToSqr(sourceEntity)));
                continue;
            }
            vec3d = hitPosition;
            entities.add(new EntityHit(entity, vec3d, entity.distanceToSqr(sourceEntity)));
        }
        return entities;
    }

    public static List<Entity> targetsFromArea(Entity caster, float range, Spell.Target.Area area, @Nullable Predicate<Entity> predicate) {
        Vec3 origin = caster.getEyePosition();
        return TargetHelper.targetsFromArea(caster, origin, range, area, predicate);
    }

    public static List<Entity> targetsFromArea(Entity centerEntity, Vec3 origin, float range, Spell.Target.Area area, @Nullable Predicate<Entity> predicate) {
        float horizontal = range * area.horizontal_range_multiplier;
        float vertical = range * area.vertical_range_multiplier;
        AABB box = centerEntity.getBoundingBox().inflate((double)(horizontal + 0.5f), (double)(vertical + 0.5f), (double)(horizontal + 0.5f));
        float squaredDistance = range * range;
        Vec3 look = centerEntity.getLookAngle();
        float angle = area.angle_degrees / 2.0f;
        return centerEntity.level().getEntities(centerEntity, box, target -> {
            Vec3 targetCenter = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
            Vec3 distanceVector = VectorHelper.distanceVector(origin, target.getBoundingBox());
            return !target.isSpectator() && target.isPickable() && (predicate == null || predicate.test((Entity)target)) && (range > 1.0f ? targetCenter.distanceToSqr(origin) <= (double)squaredDistance : distanceVector.length() <= (double)range) && (angle <= 0.0f || VectorHelper.angleBetween(look, targetCenter.subtract(origin)) <= (double)angle || VectorHelper.angleBetween(look, distanceVector) <= (double)angle) && (range < 1.0f || TargetHelper.raycastObstacleFree(centerEntity, origin, targetCenter) || TargetHelper.raycastObstacleFree(centerEntity, origin, origin.add(distanceVector)));
        });
    }

    public static boolean isInLineOfSight(Entity attacker, Entity target) {
        Vec3 origin = attacker.getEyePosition();
        Vec3 targetCenter = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        Vec3 distanceVector = VectorHelper.distanceVector(origin, target.getBoundingBox());
        return TargetHelper.raycastObstacleFree(attacker, origin, targetCenter) || TargetHelper.raycastObstacleFree(attacker, origin, origin.add(distanceVector));
    }

    private static BlockHitResult raycastObstacle(Entity entity, Vec3 start, Vec3 end) {
        return entity.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    private static boolean raycastObstacleFree(Entity entity, Vec3 start, Vec3 end) {
        BlockHitResult hit = TargetHelper.raycastObstacle(entity, start, end);
        return hit.getType() != HitResult.Type.BLOCK;
    }

    public static boolean isTargetedByPlayer(Entity entity, Player player) {
        if (entity != null && entity.level().isClientSide && player instanceof SpellCasterClient) {
            SpellCasterClient casterClient = (SpellCasterClient)player;
            List<Entity> targets = casterClient.getCurrentTargets();
            if (entity instanceof EnderDragon) {
                EnderDragon dragon = (EnderDragon)entity;
                for (EnderDragonPart part : dragon.getSubEntities()) {
                    if (!targets.contains(part)) continue;
                    return true;
                }
                return false;
            }
            return targets.contains(entity);
        }
        return false;
    }

    public static Beam.Position castBeam(LivingEntity caster, Vec3 direction, float max) {
        Vec3 start = SpellHelper.launchPoint(caster);
        Vec3 end = start.add(direction.scale((double)max));
        float length = max;
        boolean hitBlock = false;
        BlockHitResult hit = caster.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
        if (hit.getType() == HitResult.Type.BLOCK) {
            hitBlock = true;
            end = hit.getLocation();
            length = (float)start.distanceTo(hit.getLocation());
        }
        return new Beam.Position(start, end, length, hitBlock);
    }

    @Nullable
    public static Vec3 findSolidBelow(Entity entity, Vec3 position, Level world, float height) {
        BlockHitResult hit = world.clip(new ClipContext(position, position.add(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (hit.getType() == HitResult.Type.BLOCK) {
            return hit.getLocation();
        }
        return null;
    }

    @Nullable
    public static Vec3 findSolidBlockBelow(@Nullable Entity entity, Vec3 position, Level world, float height) {
        ClipContext raycast = entity != null ? new ClipContext(position, position.add(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity) : new ClipContext(position, position.add(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult hit = world.clip(raycast);
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHit = hit;
            return new Vec3(position.x(), (double)((float)blockHit.getBlockPos().getY() + 1.0f), position.z());
        }
        return null;
    }

    @Nullable
    public static Vec3 findTeleportDestination(LivingEntity entity, Vec3 look, float distance, int clearanceY) {
        Level world = entity.level();
        Vec3 start = entity.getEyePosition();
        Vec3 end = start.add(look.scale((double)distance));
        BlockHitResult hit = world.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 hitPosition = null;
        if (hit.getType() == HitResult.Type.MISS) {
            hitPosition = end;
        }
        if (hit.getType() == HitResult.Type.BLOCK && hit.getBlockPos() != null) {
            hitPosition = hit.getLocation();
        }
        if (hitPosition != null) {
            Vec3 inverseLook = look.scale(-1.0);
            Vec3 paddedHitPosition = hitPosition.add(inverseLook.scale(0.5));
            double hitDistance = start.distanceTo(paddedHitPosition);
            float reverted = 0.0f;
            while ((double)reverted < hitDistance) {
                BlockPos blockPos = new BlockPos((int)paddedHitPosition.x(), (int)paddedHitPosition.y(), (int)paddedHitPosition.z());
                if (TargetHelper.isSafeWithClearance(world, blockPos, clearanceY)) {
                    return paddedHitPosition;
                }
                reverted += 1.0f;
                paddedHitPosition = paddedHitPosition.add(inverseLook);
            }
        }
        return null;
    }

    private static boolean isSafeWithClearance(Level world, BlockPos blockPos, int clearanceY) {
        if (TargetHelper.isSafeTeleportDestination(world, blockPos)) {
            boolean clearanceSafe = true;
            for (int i = 0; i < clearanceY; ++i) {
                BlockPos clearancePos = blockPos.above(i);
                if (TargetHelper.isSafeTeleportDestination(world, clearancePos)) continue;
                clearanceSafe = false;
                break;
            }
            return clearanceSafe;
        }
        return false;
    }

    private static boolean isSafeTeleportDestination(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return !state.isSolid() && !state.isSuffocating((BlockGetter)world, pos);
    }

    private record EntityHit(Entity entity, Vec3 position, double squaredDistanceToSource) {
    }
}

