/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.mojang.serialization.Codec;
import com.petrolpark.compat.create.core.dough.IDough;
import com.petrolpark.core.badge.BadgeItem;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.Contamination;
import com.petrolpark.core.item.decay.DecayTime;
import com.petrolpark.core.item.decay.product.IDecayProduct;
import com.petrolpark.core.recipe.bogglepattern.BogglePatternHelper;
import com.petrolpark.core.recipe.book.RecipeReferenceDataComponent;
import com.petrolpark.core.shop.Shop;
import com.petrolpark.core.shop.ShopsData;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.CodecHelper;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Rotation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class PetrolparkDataComponents {
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"petrolpark");
    public static final DataComponentType<BadgeItem.BadgeAward> BADGE_AWARD = PetrolparkDataComponents.register("badge_award", builder -> builder.persistent(BadgeItem.BadgeAward.CODEC).networkSynchronized(BadgeItem.BadgeAward.STREAM_CODEC));
    public static final DataComponentType<ITeam.Provider> TEAM_PROVIDER = PetrolparkDataComponents.register("team", builder -> builder.persistent(ITeam.Provider.CODEC).networkSynchronized(ITeam.Provider.STREAM_CODEC));
    public static final DataComponentType<List<Holder<Contaminant>>> ORPHAN_CONTAMINANTS = PetrolparkDataComponents.register("contamination", builder -> builder.persistent(Contamination.ORPHAN_HOLDER_LIST_CODEC).networkSynchronized(Contamination.ORPHAN_HOLDER_LIST_STREAM_CODEC));
    public static final DataComponentType<RecipeReferenceDataComponent> RECIPE_REFERENCE = PetrolparkDataComponents.register("recipe_reference", builder -> builder.persistent(RecipeReferenceDataComponent.CODEC).networkSynchronized(RecipeReferenceDataComponent.STREAM_CODEC));
    public static final DataComponentType<IDecayProduct> DECAY_PRODUCT = PetrolparkDataComponents.register("decay_product", builder -> builder.persistent(IDecayProduct.CODEC).networkSynchronized(IDecayProduct.STREAM_CODEC));
    public static final DataComponentType<DecayTime> DECAY_TIME = PetrolparkDataComponents.register("decay_time", builder -> builder.persistent(DecayTime.CODEC).networkSynchronized(DecayTime.STREAM_CODEC));
    public static final DataComponentType<Long> DECAY_START_TIME = PetrolparkDataComponents.register("decay_start_time", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DataComponentType<Integer> BOGGLE_PATTERN = PetrolparkDataComponents.register("boggle_pattern", builder -> builder.persistent(BogglePatternHelper.SHORT_CODEC).networkSynchronized(BogglePatternHelper.SHORT_STREAM_CODEC));
    public static final DataComponentType<Holder<Shop>> SHOP = PetrolparkDataComponents.register("shop", builder -> builder.persistent(Shop.CODEC).networkSynchronized(Shop.STREAM_CODEC));
    public static final DataComponentType<ShopsData> SHOPS_DATA = PetrolparkDataComponents.register("shops_data", builder -> builder.persistent(ShopsData.CODEC));
    public static final DataComponentType<Rotation> ROTATION_WHILE_FLYING = PetrolparkDataComponents.register("rotation_while_flying", builder -> builder.persistent(Rotation.CODEC).networkSynchronized(CodecHelper.enumStream(Rotation.class)));
    public static final DataComponentType<IDough<?>> DOUGH = PetrolparkDataComponents.register("dough", builder -> builder.persistent(IDough.CODEC).networkSynchronized(IDough.STREAM_CODEC));

    private static <T> DataComponentType<T> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        DataComponentType type = ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build();
        DATA_COMPONENTS.register(name, () -> type);
        return type;
    }

    @ApiStatus.Internal
    public static final void register(IEventBus modEventBus) {
        DATA_COMPONENTS.register(modEventBus);
    }
}

