/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.compat.Mods;
import com.petrolpark.compat.SharedFeatureFlag;
import com.petrolpark.core.badge.BadgeDataProvider;
import com.petrolpark.core.registrate.PetrolparkTagGen;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class PetrolparkDatagen {
    public static void prepareDatagen() {
        for (SharedFeatureFlag flag : SharedFeatureFlag.values()) {
            flag.enable(Mods.PETROLPARK);
        }
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, lookupProvider, existingFileHelper, Collections.singletonList(new BadgeDataProvider())));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), Collections.singletonList(new LootTableProvider.SubProviderEntry(BadgeDataProvider::new, LootContextParamSets.ADVANCEMENT_REWARD)), lookupProvider));
        generator.addProvider(event.includeServer(), new PetrolparkTagGen.UnrequiredTagsProvider<Block>(output, Registries.BLOCK, lookupProvider, existingFileHelper, PetrolparkTagGen.UNREQUIRED_BLOCKS));
    }
}

