/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.util.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class PetrolparkTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return PetrolparkTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return PetrolparkTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return PetrolparkTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return PetrolparkTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static enum Contaminants {
        HIDDEN,
        NOT_PRESERVED_CRUSHING("not_preserved/crushing");

        public final TagKey<Contaminant> tag;

        private Contaminants() {
            this.tag = TagKey.create(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));
        }

        private Contaminants(String path) {
            this.tag = TagKey.create(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)Petrolpark.asResource(path));
        }

        public boolean matches(Holder<Contaminant> contaminant) {
            return contaminant.is(this.tag);
        }
    }

    public static enum MenuTypes {
        ALWAYS_SHOWS_EXTENDED_INVENTORY,
        NEVER_SHOWS_EXTENDED_INVENTORY,
        ALLOWS_MANUAL_ONLY_CRAFTING;

        public final TagKey<MenuType<?>> tag = TagKey.create((ResourceKey)Registries.MENU, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(AbstractContainerMenu menu) {
            try {
                return this.matches(menu.getType());
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
        }

        public boolean matches(Holder.Reference<MenuType<?>> holder) {
            return holder.is(this.tag);
        }

        public boolean matches(MenuType<?> menuType) {
            return PetrolparkRegistries.getHolder(BuiltInRegistries.MENU, menuType).map(this::matches).orElse(false);
        }
    }

    public static enum RecipeTypes {
        RECYCLABLE;

        public final TagKey<RecipeType<?>> tag = TagKey.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(Holder<RecipeType<?>> holder) {
            return holder.is(this.tag);
        }

        public boolean matches(RecipeType<?> recipeType) {
            return PetrolparkRegistries.getHolder(BuiltInRegistries.RECIPE_TYPE, recipeType).map(this::matches).orElse(false);
        }

        public boolean matches(Recipe<?> recipe) {
            return this.matches(recipe.getType());
        }
    }

    public static enum BlockEntityTypes {
        CONTAMINABLE_KINETIC;

        public final TagKey<BlockEntityType<?>> tag = TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(BlockEntity blockEntity) {
            return this.matches(blockEntity.getType());
        }

        public boolean matches(BlockEntityType<?> blockEntityType) {
            return PetrolparkRegistries.getHolder(BuiltInRegistries.BLOCK_ENTITY_TYPE, blockEntityType).orElseThrow().is(this.tag);
        }
    }

    public static enum Fluids {
        INCONTAMINABLE;

        public final TagKey<Fluid> tag = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidStack stack) {
            return stack.getFluid().is(this.tag);
        }

        public static final TagKey<Fluid> common(String path) {
            return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
        }
    }

    public static enum Items {
        INCONTAMINABLE,
        CONTAMINABLE_BLOCKS;

        public final TagKey<Item> tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Petrolpark.asResource(Lang.asId(this.name())));

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        public static final TagKey<Item> common(String path) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
        }
    }

    public static final class Blocks
    extends Enum<Blocks> {
        private static final /* synthetic */ Blocks[] $VALUES;

        public static Blocks[] values() {
            return (Blocks[])$VALUES.clone();
        }

        public static Blocks valueOf(String name) {
            return Enum.valueOf(Blocks.class, name);
        }

        public static final TagKey<Block> common(String path) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
        }

        private static /* synthetic */ Blocks[] $values() {
            return new Blocks[0];
        }

        static {
            $VALUES = Blocks.$values();
        }
    }
}

