/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.ponder.instruction;

import com.petrolpark.client.ponder.PonderPlayer;
import java.util.UUID;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.element.PonderElement;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.ElementLinkImpl;
import net.createmod.ponder.foundation.element.EntityElementImpl;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;

public class CreateFishingHookInstruction
extends PonderInstruction {
    protected final ElementLink<EntityElement> playerElementLink;
    protected final ElementLink<EntityElement> hookElementLink;

    protected CreateFishingHookInstruction(ElementLink<EntityElement> playerElementLink) {
        this.playerElementLink = playerElementLink;
        this.hookElementLink = new ElementLinkImpl(EntityElement.class, UUID.randomUUID());
    }

    public static ElementLink<EntityElement> add(SceneBuilder scene, ElementLink<EntityElement> player) {
        CreateFishingHookInstruction instruction = new CreateFishingHookInstruction(player);
        scene.addInstruction((PonderInstruction)instruction);
        return instruction.hookElementLink;
    }

    public boolean isComplete() {
        return true;
    }

    public void tick(PonderScene scene) {
        EntityElement element = (EntityElement)scene.resolve(this.playerElementLink);
        if (element != null) {
            element.ifPresent(entity -> {
                if (!(entity instanceof PonderPlayer)) {
                    return;
                }
                PonderPlayer player = (PonderPlayer)((Object)entity);
                PonderLevel world = scene.getWorld();
                FishingHook hook = new FishingHook((Player)player, (Level)world, 0, 0);
                EntityElementImpl handle = new EntityElementImpl((Entity)hook);
                scene.addElement((PonderElement)handle);
                scene.linkElement((PonderElement)handle, this.hookElementLink);
                world.addFreshEntity((Entity)hook);
            });
        }
    }
}

