/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.brewinandchewin;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.Mods;
import com.petrolpark.compat.brewinandchewin.BnCFluidIngredient;
import com.petrolpark.compat.create.common.processing.basinlid.LiddedBasinRecipe;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.codec.RecordDecoderBuilder;
import com.petrolpark.core.recipe.compat.CompatRecipeDeserializer;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@RequiresCreate
public class BnCFermentingRecipeDeserializer
implements CompatRecipeDeserializer<LiddedBasinRecipe> {
    public static final ResourceLocation SERIALIZER_ID = Mods.BREWIN_AND_CHEWIN.asResource("fermenting");
    public static final Decoder<Optional<LiddedBasinRecipe>> DECODER = RecordDecoderBuilder.create(instance -> instance.group(RecordDecoderBuilder.of(Ingredient.CODEC.listOf(1, 4).fieldOf("ingredients")), RecordDecoderBuilder.ofOptional(BnCFluidIngredient.DECODER, "base_fluid"), RecordDecoderBuilder.of(Codec.either((Codec)FluidStack.CODEC, (Codec)ItemStack.CODEC).fieldOf("result")), RecordDecoderBuilder.of(Codec.INT.optionalFieldOf("fermenting_time", (Object)9600)), RecordDecoderBuilder.of(Codec.INT.optionalFieldOf("temperature", (Object)3))).apply((Applicative)instance, (ingredients, bncFluidOptional, result, time, temperature) -> {
        if (!((Boolean)PetrolparkConfigs.common().brewinAndChewinFermentingInLiddedBasin.get()).booleanValue()) {
            return Optional.empty();
        }
        LiddedBasinRecipe.Builder builder = ((LiddedBasinRecipe.Builder)LiddedBasinRecipe.builder().duration((int)time)).withBubbles();
        if (bncFluidOptional.isPresent()) {
            Optional<SizedFluidIngredient> fluidOptional = ((BnCFluidIngredient)bncFluidOptional.get()).asNeoIngredient();
            if (fluidOptional.isEmpty()) {
                return Optional.empty();
            }
            builder.require(fluidOptional.get());
        }
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            builder.require(ingredient);
        }
        switch (temperature) {
            case 3: {
                break;
            }
            case 4: {
                builder.requiresHeat(HeatCondition.HEATED);
                break;
            }
            case 5: {
                builder.requiresHeat(HeatCondition.SUPERHEATED);
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        result.map(arg_0 -> ((LiddedBasinRecipe.Builder)builder).output(arg_0), arg_0 -> ((LiddedBasinRecipe.Builder)builder).output(arg_0));
        return Optional.of((LiddedBasinRecipe)builder.build());
    }));

    @Override
    public ResourceLocation serializerId() {
        return SERIALIZER_ID;
    }

    @Override
    public Decoder<Optional<LiddedBasinRecipe>> decoder() {
        return DECODER;
    }

    @Override
    public ResourceLocation createId(ResourceLocation baseId) {
        return baseId.withPrefix("petrolpark/lidded_basin/");
    }

    public String toString() {
        return "BnC Fermenting -> petrolpark Lidded Basin";
    }
}

