/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.brewinandchewin;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.petrolpark.RequiresCreate;
import com.petrolpark.core.codec.EitherDecoder;
import com.petrolpark.core.codec.RecordDecoderBuilder;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SingleFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.TagFluidIngredient;

@RequiresCreate
public record BnCFluidIngredient(FluidIngredient ingredient, int amount, String unit) {
    public static final String UNIT_LITERS = "liters";
    public static final String UNIT_MILLIBUCKETS = "millibuckets";
    public static final Decoder<BnCFluidIngredient> DECODER = RecordDecoderBuilder.create(instance -> instance.group(RecordDecoderBuilder.of(EitherDecoder.withAlternative(FluidIngredient.CODEC, EitherDecoder.withAlternative(RecordDecoderBuilder.create(ingredientInstance -> ingredientInstance.group(RecordDecoderBuilder.of(RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).flatMap(set -> {
        DataResult dataResult;
        if (set instanceof HolderSet.Named) {
            HolderSet.Named tagSet = (HolderSet.Named)set;
            dataResult = DataResult.success((Object)tagSet.key());
        } else {
            dataResult = DataResult.error(() -> "Only supports Tags defined in their own files");
        }
        return dataResult;
    }).fieldOf("tag")), BnCFluidIngredient.componentDecoder()).apply((Applicative)ingredientInstance, (tag, components) -> new TagFluidIngredient(tag))), RecordDecoderBuilder.create(ingredientInstance -> ingredientInstance.group(RecordDecoderBuilder.of(FluidStack.FLUID_NON_EMPTY_CODEC.fieldOf("id")), BnCFluidIngredient.componentDecoder()).apply((Applicative)ingredientInstance, (fluid, components) -> new SingleFluidIngredient(fluid))))).fieldOf("ingredient")), RecordDecoderBuilder.of(Codec.INT.fieldOf("amount")), RecordDecoderBuilder.of(Codec.STRING.fieldOf("unit"))).apply((Applicative)instance, BnCFluidIngredient::new));

    private static final <O> RecordDecoderBuilder<O, DataComponentPatch> componentDecoder() {
        return RecordDecoderBuilder.ofOptional(DataComponentPatch.CODEC.flatMap(components -> components.isEmpty() ? DataResult.success((Object)components) : DataResult.error(() -> "Specific Components not supported in recipe")), "components", DataComponentPatch.EMPTY);
    }

    public Optional<SizedFluidIngredient> asNeoIngredient() {
        if (!this.unit.equals(UNIT_MILLIBUCKETS) && !this.unit.equals(UNIT_LITERS)) {
            return Optional.empty();
        }
        return Optional.of(new SizedFluidIngredient(this.ingredient(), this.amount()));
    }
}

