/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.basinlid;

import com.petrolpark.PetrolparkParticleTypes;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.common.processing.basinlid.BasinLidBlock;
import com.petrolpark.compat.create.common.processing.basinlid.LiddedBasinRecipe;
import com.petrolpark.compat.create.core.block.entity.DirectlyAboveBasinOperatingBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BasinLidBlockEntity
extends DirectlyAboveBasinOperatingBlockEntity {
    protected final Object recipeCacheKey = new Object();
    public int processingTicksRemaining = -1;
    protected boolean bubbling;
    public static final Vec3 PARTICLE_OFFSET = new Vec3(-0.3125, 0.5625, 0.0);

    public BasinLidBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        Level level = this.getLevel();
        if (level != null && this.processingTicksRemaining > 0) {
            if (level.isClientSide()) {
                this.renderParticles();
            }
            if (this.processingTicksRemaining % 20 == 0) {
                level.playSound(null, this.worldPosition, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.75f, 0.5f);
            }
            --this.processingTicksRemaining;
            if (this.processingTicksRemaining == 0) {
                this.applyBasinRecipe();
                this.basinChecker.scheduleUpdate();
            }
            return;
        }
    }

    protected boolean isRunning() {
        return this.processingTicksRemaining > 0;
    }

    protected boolean updateBasin() {
        if (this.isRunning()) {
            return true;
        }
        Level level = this.getLevel();
        if (level == null || level.isClientSide()) {
            return true;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (!basin.filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        if (this.processingTicksRemaining > 0) {
            return;
        }
        super.startProcessingBasin();
        this.resetProcessingTime();
    }

    public boolean continueWithPreviousRecipe() {
        this.resetProcessingTime();
        return true;
    }

    public void resetProcessingTime() {
        this.processingTicksRemaining = this.getCurrentProcessingRecipe().map(ProcessingRecipe::getProcessingDuration).orElse(400);
        this.bubbling = this.getCurrentLiddedBasinRecipe().map(LiddedBasinRecipe::bubbles).orElse(false);
    }

    protected void onBasinRemoved() {
        this.processingTicksRemaining = -1;
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value().getType() == CreateRecipeTypes.LIDDED_BASIN.getType();
    }

    protected Object getRecipeCacheKey() {
        return this.recipeCacheKey;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderParticles() {
        Level level = this.getLevel();
        if (level == null || !this.bubbling || this.processingTicksRemaining % 5 != 0 || level.getRandom().nextInt(5) != 0) {
            return;
        }
        Vec3 loc = VecHelper.getCenterOf((Vec3i)this.getBlockPos()).add(VecHelper.rotate((Vec3)PARTICLE_OFFSET, (double)AngleHelper.horizontalAngle((Direction)((Direction)this.getBlockState().getValue((Property)BasinLidBlock.FACING))), (Direction.Axis)Direction.Axis.Y));
        level.addParticle((ParticleOptions)PetrolparkParticleTypes.AIR_BUBBLE.get(), loc.x(), loc.y(), loc.z(), 0.0, 0.2, 0.0);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.processingTicksRemaining = compound.getInt("Ticks");
        this.bubbling = compound.getBoolean("Bubbling");
        super.read(compound, registries, clientPacket);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Ticks", this.processingTicksRemaining);
        compound.putBoolean("Bubbling", this.bubbling);
        super.write(compound, registries, clientPacket);
    }

    protected Optional<ProcessingRecipe<?, ?>> getCurrentProcessingRecipe() {
        Optional<ProcessingRecipe<?, ?>> optional;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe pr = (ProcessingRecipe)recipe;
            optional = Optional.of(pr);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    protected Optional<LiddedBasinRecipe> getCurrentLiddedBasinRecipe() {
        return this.getCurrentProcessingRecipe().map(r -> {
            LiddedBasinRecipe lbr;
            return r instanceof LiddedBasinRecipe ? (lbr = (LiddedBasinRecipe)((Object)r)) : null;
        });
    }
}

