/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.extrusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.Create;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrusionMovementBehaviour;
import com.petrolpark.core.recipe.ingredient.BlockHolderSetIngredient;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.registry.SimpleRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class ExtrusionRecipe
implements Recipe<Input> {
    public static final MapCodec<ExtrusionRecipe> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtrusionRecipe> STREAM_CODEC;
    private final HolderSet<Block> inputs;
    public final Ingredient itemIngredient;
    private final BlockState output;

    public ExtrusionRecipe(HolderSet<Block> inputs, BlockState output) {
        this.inputs = inputs;
        this.itemIngredient = new BlockHolderSetIngredient(inputs).toVanilla();
        this.output = output;
    }

    public HolderSet<Block> inputs() {
        return this.inputs;
    }

    public BlockState output() {
        return this.output;
    }

    public boolean matches(@Nonnull Input input, @Nonnull Level level) {
        return input.state().is(this.inputs());
    }

    public ItemStack assemble(@Nonnull Input input, @Nonnull HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)this.extrude(input.state(), input.extrusionDirection()).getBlock());
    }

    public BlockState extrude(@Nonnull BlockState input, @Nullable Direction extrusionDirection) {
        if (input.is(this.inputs())) {
            BlockState output = this.output();
            if (extrusionDirection != null) {
                if (output.hasProperty((Property)BlockStateProperties.FACING)) {
                    output = (BlockState)this.output().setValue((Property)BlockStateProperties.FACING, (Comparable)extrusionDirection);
                } else if (output.hasProperty((Property)BlockStateProperties.AXIS)) {
                    output = (BlockState)this.output().setValue((Property)BlockStateProperties.AXIS, (Comparable)extrusionDirection.getAxis());
                }
            }
            return output;
        }
        return input;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)this.itemIngredient, (Object[])new Ingredient[0]);
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)this.output().getBlock());
    }

    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return this.getResultItem();
    }

    public RecipeSerializer<ExtrusionRecipe> getSerializer() {
        return CreateRecipeTypes.EXTRUSION.getSerializer();
    }

    public RecipeType<ExtrusionRecipe> getType() {
        return CreateRecipeTypes.EXTRUSION.getType();
    }

    static {
        MovementBehaviour.REGISTRY.registerProvider((SimpleRegistry.Provider)Create.EXTRUSION_MOVEMENT_BEHAVIOUR_PROVIDER);
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("inputs").forGetter(ExtrusionRecipe::inputs), (App)BlockState.CODEC.fieldOf("output").forGetter(ExtrusionRecipe::output)).apply((Applicative)instance, ExtrusionRecipe::new));
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BLOCK), ExtrusionRecipe::inputs, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), ExtrusionRecipe::output, ExtrusionRecipe::new);
    }

    public record Input(BlockState state, Direction extrusionDirection) implements RecipeInput
    {
        public ItemStack getItem(int index) {
            return new ItemStack((ItemLike)this.state.getBlock());
        }

        public int size() {
            return 1;
        }
    }

    public static class MovementBehaviourProvider
    implements SimpleRegistry.Provider<Block, MovementBehaviour> {
        private RecipeManager recipeManager = null;

        @Nullable
        public MovementBehaviour get(Block block) {
            if (this.recipeManager == null) {
                return null;
            }
            return this.recipeManager.getAllRecipesFor(CreateRecipeTypes.EXTRUSION.getType(ExtrusionRecipe.class)).stream().filter(rh -> ((ExtrusionRecipe)rh.value()).inputs().contains((Holder)block.builtInRegistryHolder())).findFirst().map(ExtrusionMovementBehaviour::new).orElse(null);
        }

        @SubscribeEvent
        public final void onRecipesUpdated(RecipesUpdatedEvent event) {
            this.recipeManager = event.getRecipeManager();
            MovementBehaviour.REGISTRY.invalidate();
        }
    }

    public static class Serializer
    implements RecipeSerializer<ExtrusionRecipe> {
        public MapCodec<ExtrusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ExtrusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

